/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.internal.GsonPreconditions;
import com.google.gson.internal.GsonTypes;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Objects;

final class GsonTypes$WildcardTypeImpl
implements Serializable,
WildcardType {
    private final Type upperBound;
    private final Type lowerBound;
    private static final long serialVersionUID = 0L;

    public GsonTypes$WildcardTypeImpl(Type[] typeArray, Type[] typeArray2) {
        GsonPreconditions.checkArgument(typeArray2.length <= 1);
        GsonPreconditions.checkArgument(typeArray.length == 1);
        if (typeArray2.length == 1) {
            Objects.requireNonNull(typeArray2[0]);
            GsonTypes.checkNotPrimitive(typeArray2[0]);
            GsonPreconditions.checkArgument(typeArray[0] == Object.class);
            this.lowerBound = GsonTypes.canonicalize(typeArray2[0]);
            this.upperBound = Object.class;
        } else {
            Objects.requireNonNull(typeArray[0]);
            GsonTypes.checkNotPrimitive(typeArray[0]);
            this.lowerBound = null;
            this.upperBound = GsonTypes.canonicalize(typeArray[0]);
        }
    }

    @Override
    public Type[] getUpperBounds() {
        return new Type[]{this.upperBound};
    }

    @Override
    public Type[] getLowerBounds() {
        Type[] typeArray;
        if (this.lowerBound != null) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = this.lowerBound;
        } else {
            typeArray = GsonTypes.EMPTY_TYPE_ARRAY;
        }
        return typeArray;
    }

    public boolean equals(Object object) {
        return object instanceof WildcardType && GsonTypes.equals(this, (WildcardType)object);
    }

    public int hashCode() {
        return (this.lowerBound != null ? 31 + this.lowerBound.hashCode() : 1) ^ 31 + this.upperBound.hashCode();
    }

    public String toString() {
        if (this.lowerBound != null) {
            return "? super " + GsonTypes.typeToString(this.lowerBound);
        }
        if (this.upperBound == Object.class) {
            return "?";
        }
        return "? extends " + GsonTypes.typeToString(this.upperBound);
    }
}

