/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.ReflectionAccessFilter;
import com.google.gson.ReflectionAccessFilter$FilterResult;
import com.google.gson.internal.ReflectionAccessFilterHelper$AccessChecker;
import java.lang.reflect.AccessibleObject;
import java.util.List;

public class ReflectionAccessFilterHelper {
    private ReflectionAccessFilterHelper() {
    }

    public static boolean isJavaType(Class<?> clazz) {
        return ReflectionAccessFilterHelper.isJavaType(clazz.getName());
    }

    private static boolean isJavaType(String string) {
        return string.startsWith("java.") || string.startsWith("javax.");
    }

    public static boolean isAndroidType(Class<?> clazz) {
        return ReflectionAccessFilterHelper.isAndroidType(clazz.getName());
    }

    private static boolean isAndroidType(String string) {
        return string.startsWith("android.") || string.startsWith("androidx.") || ReflectionAccessFilterHelper.isJavaType(string);
    }

    public static boolean isAnyPlatformType(Class<?> clazz) {
        String string = clazz.getName();
        return ReflectionAccessFilterHelper.isAndroidType(string) || string.startsWith("kotlin.") || string.startsWith("kotlinx.") || string.startsWith("scala.");
    }

    public static ReflectionAccessFilter$FilterResult getFilterResult(List<ReflectionAccessFilter> list, Class<?> clazz) {
        for (ReflectionAccessFilter reflectionAccessFilter : list) {
            ReflectionAccessFilter$FilterResult reflectionAccessFilter$FilterResult = reflectionAccessFilter.check(clazz);
            if (reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.INDECISIVE) continue;
            return reflectionAccessFilter$FilterResult;
        }
        return ReflectionAccessFilter$FilterResult.ALLOW;
    }

    public static boolean canAccess(AccessibleObject accessibleObject, Object object) {
        return ReflectionAccessFilterHelper$AccessChecker.INSTANCE.canAccess(accessibleObject, object);
    }
}

