/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.NumberLimits;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.math.BigInteger;

class TypeAdapters$17
extends TypeAdapter<BigInteger> {
    TypeAdapters$17() {
    }

    @Override
    public BigInteger read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        String string = jsonReader.nextString();
        try {
            return NumberLimits.parseBigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonSyntaxException("Failed parsing '" + string + "' as BigInteger; at path " + jsonReader.getPreviousPath(), numberFormatException);
        }
    }

    @Override
    public void write(JsonWriter jsonWriter, BigInteger bigInteger) {
        jsonWriter.value(bigInteger);
    }
}

