/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM;

import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMInvoker;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.IDispatch;
import com.sun.jna.platform.win32.COM.IUnknown;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;

public class COMBindingBaseObject
extends COMInvoker {
    public static final WinDef.LCID LOCALE_USER_DEFAULT = Kernel32.INSTANCE.GetUserDefaultLCID();
    public static final WinDef.LCID LOCALE_SYSTEM_DEFAULT = Kernel32.INSTANCE.GetSystemDefaultLCID();
    private IUnknown iUnknown;
    private IDispatch iDispatch;
    private PointerByReference pDispatch = new PointerByReference();
    private PointerByReference pUnknown = new PointerByReference();

    public COMBindingBaseObject(IDispatch iDispatch) {
        this.iDispatch = iDispatch;
    }

    public COMBindingBaseObject(Guid.CLSID cLSID, boolean bl) {
        this(cLSID, bl, 21);
    }

    public COMBindingBaseObject(Guid.CLSID cLSID, boolean bl, int n) {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        this.init(bl, cLSID, n);
    }

    public COMBindingBaseObject(String string, boolean bl, int n) throws COMException {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        Guid.CLSID.ByReference byReference = new Guid.CLSID.ByReference();
        WinNT.HRESULT hRESULT = Ole32.INSTANCE.CLSIDFromProgID(string, byReference);
        COMUtils.checkRC(hRESULT);
        this.init(bl, byReference, n);
    }

    public COMBindingBaseObject(String string, boolean bl) throws COMException {
        this(string, bl, 21);
    }

    private void init(boolean bl, Guid.GUID gUID, int n) throws COMException {
        WinNT.HRESULT hRESULT;
        if (bl) {
            hRESULT = OleAuto.INSTANCE.GetActiveObject(gUID, null, this.pUnknown);
            if (COMUtils.SUCCEEDED(hRESULT)) {
                this.iUnknown = new Unknown(this.pUnknown.getValue());
                hRESULT = this.iUnknown.QueryInterface(new Guid.REFIID(IDispatch.IID_IDISPATCH), this.pDispatch);
            } else {
                hRESULT = Ole32.INSTANCE.CoCreateInstance(gUID, null, n, IDispatch.IID_IDISPATCH, this.pDispatch);
            }
        } else {
            hRESULT = Ole32.INSTANCE.CoCreateInstance(gUID, null, n, IDispatch.IID_IDISPATCH, this.pDispatch);
        }
        COMUtils.checkRC(hRESULT);
        this.iDispatch = new Dispatch(this.pDispatch.getValue());
    }

    public IDispatch getIDispatch() {
        return this.iDispatch;
    }

    public PointerByReference getIDispatchPointer() {
        return this.pDispatch;
    }

    public IUnknown getIUnknown() {
        return this.iUnknown;
    }

    public PointerByReference getIUnknownPointer() {
        return this.pUnknown;
    }

    public void release() {
        if (this.iDispatch != null) {
            this.iDispatch.Release();
        }
    }

    protected WinNT.HRESULT oleMethod(int n, Variant.VARIANT.ByReference byReference, String string, Variant.VARIANT[] vARIANTArray) throws COMException {
        WString[] wStringArray = new WString[]{new WString(string)};
        OaIdl.DISPIDByReference dISPIDByReference = new OaIdl.DISPIDByReference();
        WinNT.HRESULT hRESULT = this.iDispatch.GetIDsOfNames(new Guid.REFIID(Guid.IID_NULL), wStringArray, 1, LOCALE_USER_DEFAULT, dISPIDByReference);
        COMUtils.checkRC(hRESULT);
        return this.oleMethod(n, byReference, dISPIDByReference.getValue(), vARIANTArray);
    }

    protected WinNT.HRESULT oleMethod(int n, Variant.VARIANT.ByReference byReference, OaIdl.DISPID dISPID, Variant.VARIANT[] vARIANTArray) throws COMException {
        int n2;
        int n3 = 0;
        Variant.VARIANT[] vARIANTArray2 = null;
        OleAuto.DISPPARAMS.ByReference byReference2 = new OleAuto.DISPPARAMS.ByReference();
        OaIdl.EXCEPINFO.ByReference byReference3 = new OaIdl.EXCEPINFO.ByReference();
        IntByReference intByReference = new IntByReference();
        if (vARIANTArray != null && vARIANTArray.length > 0) {
            n3 = vARIANTArray.length;
            vARIANTArray2 = new Variant.VARIANT[n3];
            n2 = n3;
            for (int i = 0; i < n3; ++i) {
                vARIANTArray2[i] = vARIANTArray[--n2];
            }
        }
        if (n == 4) {
            byReference2.setRgdispidNamedArgs(new OaIdl.DISPID[]{OaIdl.DISPID_PROPERTYPUT});
        }
        if (n3 > 0) {
            byReference2.setArgs(vARIANTArray2);
            byReference2.write();
        }
        n2 = n == 1 || n == 2 ? 3 : n;
        WinNT.HRESULT hRESULT = this.iDispatch.Invoke(dISPID, new Guid.REFIID(Guid.IID_NULL), LOCALE_SYSTEM_DEFAULT, new WinDef.WORD((long)n2), byReference2, byReference, byReference3, intByReference);
        COMUtils.checkRC(hRESULT, byReference3, intByReference);
        return hRESULT;
    }

    protected WinNT.HRESULT oleMethod(int n, Variant.VARIANT.ByReference byReference, String string, Variant.VARIANT vARIANT) throws COMException {
        return this.oleMethod(n, byReference, string, new Variant.VARIANT[]{vARIANT});
    }

    protected WinNT.HRESULT oleMethod(int n, Variant.VARIANT.ByReference byReference, OaIdl.DISPID dISPID, Variant.VARIANT vARIANT) throws COMException {
        return this.oleMethod(n, byReference, dISPID, new Variant.VARIANT[]{vARIANT});
    }

    protected WinNT.HRESULT oleMethod(int n, Variant.VARIANT.ByReference byReference, String string) throws COMException {
        return this.oleMethod(n, byReference, string, (Variant.VARIANT[])null);
    }

    protected WinNT.HRESULT oleMethod(int n, Variant.VARIANT.ByReference byReference, OaIdl.DISPID dISPID) throws COMException {
        return this.oleMethod(n, byReference, dISPID, (Variant.VARIANT[])null);
    }

    @Deprecated
    protected WinNT.HRESULT oleMethod(int n, Variant.VARIANT.ByReference byReference, IDispatch iDispatch, String string, Variant.VARIANT[] vARIANTArray) throws COMException {
        if (iDispatch == null) {
            throw new COMException("pDisp (IDispatch) parameter is null!");
        }
        WString[] wStringArray = new WString[]{new WString(string)};
        OaIdl.DISPIDByReference dISPIDByReference = new OaIdl.DISPIDByReference();
        WinNT.HRESULT hRESULT = iDispatch.GetIDsOfNames(new Guid.REFIID(Guid.IID_NULL), wStringArray, 1, LOCALE_USER_DEFAULT, dISPIDByReference);
        COMUtils.checkRC(hRESULT);
        return this.oleMethod(n, byReference, iDispatch, dISPIDByReference.getValue(), vARIANTArray);
    }

    @Deprecated
    protected WinNT.HRESULT oleMethod(int n, Variant.VARIANT.ByReference byReference, IDispatch iDispatch, OaIdl.DISPID dISPID, Variant.VARIANT[] vARIANTArray) throws COMException {
        int n2;
        if (iDispatch == null) {
            throw new COMException("pDisp (IDispatch) parameter is null!");
        }
        int n3 = 0;
        Variant.VARIANT[] vARIANTArray2 = null;
        OleAuto.DISPPARAMS.ByReference byReference2 = new OleAuto.DISPPARAMS.ByReference();
        OaIdl.EXCEPINFO.ByReference byReference3 = new OaIdl.EXCEPINFO.ByReference();
        IntByReference intByReference = new IntByReference();
        if (vARIANTArray != null && vARIANTArray.length > 0) {
            n3 = vARIANTArray.length;
            vARIANTArray2 = new Variant.VARIANT[n3];
            n2 = n3;
            for (int i = 0; i < n3; ++i) {
                vARIANTArray2[i] = vARIANTArray[--n2];
            }
        }
        if (n == 4) {
            byReference2.setRgdispidNamedArgs(new OaIdl.DISPID[]{OaIdl.DISPID_PROPERTYPUT});
        }
        if (n3 > 0) {
            byReference2.setArgs(vARIANTArray2);
            byReference2.write();
        }
        n2 = n == 1 || n == 2 ? 3 : n;
        WinNT.HRESULT hRESULT = iDispatch.Invoke(dISPID, new Guid.REFIID(Guid.IID_NULL), LOCALE_SYSTEM_DEFAULT, new WinDef.WORD((long)n2), byReference2, byReference, byReference3, intByReference);
        COMUtils.checkRC(hRESULT, byReference3, intByReference);
        return hRESULT;
    }

    @Deprecated
    protected WinNT.HRESULT oleMethod(int n, Variant.VARIANT.ByReference byReference, IDispatch iDispatch, String string, Variant.VARIANT vARIANT) throws COMException {
        return this.oleMethod(n, byReference, iDispatch, string, new Variant.VARIANT[]{vARIANT});
    }

    @Deprecated
    protected WinNT.HRESULT oleMethod(int n, Variant.VARIANT.ByReference byReference, IDispatch iDispatch, OaIdl.DISPID dISPID, Variant.VARIANT vARIANT) throws COMException {
        return this.oleMethod(n, byReference, iDispatch, dISPID, new Variant.VARIANT[]{vARIANT});
    }

    @Deprecated
    protected WinNT.HRESULT oleMethod(int n, Variant.VARIANT.ByReference byReference, IDispatch iDispatch, String string) throws COMException {
        return this.oleMethod(n, byReference, iDispatch, string, (Variant.VARIANT[])null);
    }

    @Deprecated
    protected WinNT.HRESULT oleMethod(int n, Variant.VARIANT.ByReference byReference, IDispatch iDispatch, OaIdl.DISPID dISPID) throws COMException {
        return this.oleMethod(n, byReference, iDispatch, dISPID, (Variant.VARIANT[])null);
    }

    @Deprecated
    protected void checkFailed(WinNT.HRESULT hRESULT) {
        COMUtils.checkRC(hRESULT);
    }
}

