/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.util.Deque;
import java.util.Map;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC$MDCCloseable;
import org.slf4j.helpers.NOPMDCAdapter;
import org.slf4j.helpers.Reporter;
import org.slf4j.helpers.SubstituteServiceProvider;
import org.slf4j.spi.MDCAdapter;
import org.slf4j.spi.SLF4JServiceProvider;

public class MDC {
    static final String NULL_MDCA_URL = "http://www.slf4j.org/codes.html#null_MDCA";
    private static final String MDC_APAPTER_CANNOT_BE_NULL_MESSAGE = "MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA";
    static final String NO_STATIC_MDC_BINDER_URL = "http://www.slf4j.org/codes.html#no_static_mdc_binder";
    static MDCAdapter MDC_ADAPTER;

    private MDC() {
    }

    private static MDCAdapter getMDCAdapterGivenByProvider() {
        SLF4JServiceProvider sLF4JServiceProvider = LoggerFactory.getProvider();
        if (sLF4JServiceProvider != null) {
            MDCAdapter mDCAdapter = sLF4JServiceProvider.getMDCAdapter();
            MDC.emitTemporaryMDCAdapterWarningIfNeeded(sLF4JServiceProvider);
            return mDCAdapter;
        }
        Reporter.error("Failed to find provider.");
        Reporter.error("Defaulting to no-operation MDCAdapter implementation.");
        return new NOPMDCAdapter();
    }

    private static void emitTemporaryMDCAdapterWarningIfNeeded(SLF4JServiceProvider sLF4JServiceProvider) {
        boolean bl = sLF4JServiceProvider instanceof SubstituteServiceProvider;
        if (bl) {
            Reporter.info("Temporary mdcAdapter given by SubstituteServiceProvider.");
            Reporter.info("This mdcAdapter will be replaced after backend initialization has completed.");
        }
    }

    public static void put(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        MDC.getMDCAdapter().put(string, string2);
    }

    public static MDC$MDCCloseable putCloseable(String string, String string2) {
        MDC.put(string, string2);
        return new MDC$MDCCloseable(string, null);
    }

    public static String get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        return MDC.getMDCAdapter().get(string);
    }

    public static void remove(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        MDC.getMDCAdapter().remove(string);
    }

    public static void clear() {
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        MDC.getMDCAdapter().clear();
    }

    public static Map<String, String> getCopyOfContextMap() {
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        return MDC.getMDCAdapter().getCopyOfContextMap();
    }

    public static void setContextMap(Map<String, String> map) {
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        MDC.getMDCAdapter().setContextMap(map);
    }

    public static MDCAdapter getMDCAdapter() {
        if (MDC_ADAPTER == null) {
            MDC_ADAPTER = MDC.getMDCAdapterGivenByProvider();
        }
        return MDC_ADAPTER;
    }

    static void setMDCAdapter(MDCAdapter mDCAdapter) {
        if (mDCAdapter == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        MDC_ADAPTER = mDCAdapter;
    }

    public static void pushByKey(String string, String string2) {
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        MDC.getMDCAdapter().pushByKey(string, string2);
    }

    public static String popByKey(String string) {
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        return MDC.getMDCAdapter().popByKey(string);
    }

    public Deque<String> getCopyOfDequeByKey(String string) {
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        return MDC.getMDCAdapter().getCopyOfDequeByKey(string);
    }
}

