/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.simple;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.slf4j.helpers.Reporter;
import org.slf4j.simple.OutputChoice;

public class SimpleLoggerConfiguration {
    private static final String CONFIGURATION_FILE = "simplelogger.properties";
    static int DEFAULT_LOG_LEVEL_DEFAULT = 20;
    int defaultLogLevel = DEFAULT_LOG_LEVEL_DEFAULT;
    private static final boolean SHOW_DATE_TIME_DEFAULT = false;
    boolean showDateTime = false;
    private static final String DATE_TIME_FORMAT_STR_DEFAULT;
    private static String dateTimeFormatStr;
    DateFormat dateFormatter = null;
    private static final boolean SHOW_THREAD_NAME_DEFAULT = true;
    boolean showThreadName = true;
    private static final boolean SHOW_THREAD_ID_DEFAULT = false;
    boolean showThreadId = false;
    static final boolean SHOW_LOG_NAME_DEFAULT = true;
    boolean showLogName = true;
    private static final boolean SHOW_SHORT_LOG_NAME_DEFAULT = false;
    boolean showShortLogName = false;
    private static final boolean LEVEL_IN_BRACKETS_DEFAULT = false;
    boolean levelInBrackets = false;
    private static final String LOG_FILE_DEFAULT = "System.err";
    private String logFile = "System.err";
    OutputChoice outputChoice = null;
    private static final boolean CACHE_OUTPUT_STREAM_DEFAULT = false;
    private boolean cacheOutputStream = false;
    private static final String WARN_LEVELS_STRING_DEFAULT = "WARN";
    String warnLevelString = "WARN";
    private final Properties properties = new Properties();

    void init() {
        this.loadProperties();
        String string = this.getStringProperty("org.slf4j.simpleLogger.defaultLogLevel", null);
        if (string != null) {
            this.defaultLogLevel = SimpleLoggerConfiguration.stringToLevel(string);
        }
        this.showLogName = this.getBooleanProperty("org.slf4j.simpleLogger.showLogName", true);
        this.showShortLogName = this.getBooleanProperty("org.slf4j.simpleLogger.showShortLogName", false);
        this.showDateTime = this.getBooleanProperty("org.slf4j.simpleLogger.showDateTime", false);
        this.showThreadName = this.getBooleanProperty("org.slf4j.simpleLogger.showThreadName", true);
        this.showThreadId = this.getBooleanProperty("org.slf4j.simpleLogger.showThreadId", false);
        dateTimeFormatStr = this.getStringProperty("org.slf4j.simpleLogger.dateTimeFormat", DATE_TIME_FORMAT_STR_DEFAULT);
        this.levelInBrackets = this.getBooleanProperty("org.slf4j.simpleLogger.levelInBrackets", false);
        this.warnLevelString = this.getStringProperty("org.slf4j.simpleLogger.warnLevelString", WARN_LEVELS_STRING_DEFAULT);
        this.logFile = this.getStringProperty("org.slf4j.simpleLogger.logFile", this.logFile);
        this.cacheOutputStream = this.getBooleanProperty("org.slf4j.simpleLogger.cacheOutputStream", false);
        this.outputChoice = SimpleLoggerConfiguration.computeOutputChoice(this.logFile, this.cacheOutputStream);
        if (dateTimeFormatStr != null) {
            try {
                this.dateFormatter = new SimpleDateFormat(dateTimeFormatStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Reporter.error("Bad date format in simplelogger.properties; will output relative time", illegalArgumentException);
            }
        }
    }

    private void loadProperties() {
        InputStream inputStream = AccessController.doPrivileged(() -> {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                return classLoader.getResourceAsStream(CONFIGURATION_FILE);
            }
            return ClassLoader.getSystemResourceAsStream(CONFIGURATION_FILE);
        });
        if (null != inputStream) {
            try {
                this.properties.load(inputStream);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    String getStringProperty(String string, String string2) {
        String string3 = this.getStringProperty(string);
        return string3 == null ? string2 : string3;
    }

    boolean getBooleanProperty(String string, boolean bl) {
        String string2 = this.getStringProperty(string);
        return string2 == null ? bl : "true".equalsIgnoreCase(string2);
    }

    String getStringProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string2 == null ? this.properties.getProperty(string) : string2;
    }

    static int stringToLevel(String string) {
        if ("trace".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("debug".equalsIgnoreCase(string)) {
            return 10;
        }
        if ("info".equalsIgnoreCase(string)) {
            return 20;
        }
        if ("warn".equalsIgnoreCase(string)) {
            return 30;
        }
        if ("error".equalsIgnoreCase(string)) {
            return 40;
        }
        if ("off".equalsIgnoreCase(string)) {
            return 50;
        }
        return 20;
    }

    private static OutputChoice computeOutputChoice(String string, boolean bl) {
        if (LOG_FILE_DEFAULT.equalsIgnoreCase(string)) {
            if (bl) {
                return new OutputChoice(OutputChoice.OutputChoiceType.CACHED_SYS_ERR);
            }
            return new OutputChoice(OutputChoice.OutputChoiceType.SYS_ERR);
        }
        if ("System.out".equalsIgnoreCase(string)) {
            if (bl) {
                return new OutputChoice(OutputChoice.OutputChoiceType.CACHED_SYS_OUT);
            }
            return new OutputChoice(OutputChoice.OutputChoiceType.SYS_OUT);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            return new OutputChoice(printStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Reporter.error("Could not open [" + string + "]. Defaulting to System.err", fileNotFoundException);
            return new OutputChoice(OutputChoice.OutputChoiceType.SYS_ERR);
        }
    }

    static {
        dateTimeFormatStr = DATE_TIME_FORMAT_STR_DEFAULT = null;
    }
}

