/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.os.NetworkParams;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

@ThreadSafe
public abstract class AbstractNetworkParams
implements NetworkParams {
    private static final String NAMESERVER = "nameserver";

    @Override
    public String getDomainName() {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = InetAddress.getLoopbackAddress();
        }
        return inetAddress.getCanonicalHostName();
    }

    @Override
    public String getHostName() {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = InetAddress.getLoopbackAddress();
        }
        String string = inetAddress.getHostName();
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    @Override
    public String[] getDnsServers() {
        List<String> list = FileUtil.readFile("/etc/resolv.conf");
        String string = NAMESERVER;
        int n = 3;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size() && arrayList.size() < n; ++i) {
            String string2;
            String string3 = list.get(i);
            if (!string3.startsWith(string) || (string2 = string3.substring(string.length()).replaceFirst("^[ \t]+", "")).length() == 0 || string2.charAt(0) == '#' || string2.charAt(0) == ';') continue;
            String string4 = string2.split("[ \t#;]", 2)[0];
            arrayList.add(string4);
        }
        return arrayList.toArray(new String[0]);
    }

    protected static String searchGateway(List<String> list) {
        for (String string : list) {
            String string2 = string.replaceFirst("^\\s+", "");
            if (!string2.startsWith("gateway:")) continue;
            String[] stringArray = ParseUtil.whitespaces.split(string2);
            if (stringArray.length < 2) {
                return "";
            }
            return stringArray[1].split("%")[0];
        }
        return "";
    }

    public String toString() {
        return String.format(Locale.ROOT, "Host name: %s, Domain name: %s, DNS servers: %s, IPv4 Gateway: %s, IPv6 Gateway: %s", this.getHostName(), this.getDomainName(), Arrays.toString(this.getDnsServers()), this.getIpv4DefaultGateway(), this.getIpv6DefaultGateway());
    }
}

