/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.IPHlpAPI;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Win32Exception;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.ByRef;
import oshi.software.common.AbstractNetworkParams;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
final class WindowsNetworkParams
extends AbstractNetworkParams {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsNetworkParams.class);
    private static final int COMPUTER_NAME_DNS_DOMAIN_FULLY_QUALIFIED = 3;

    WindowsNetworkParams() {
    }

    @Override
    public String getDomainName() {
        char[] cArray = new char[256];
        try (ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference(cArray.length);){
            if (!Kernel32.INSTANCE.GetComputerNameEx(3, cArray, closeableIntByReference)) {
                LOG.error("Failed to get dns domain name. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
                String string = "";
                return string;
            }
        }
        return Native.toString(cArray);
    }

    @Override
    public String[] getDnsServers() {
        try (ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference();){
            Memory memory;
            block16: {
                int n = IPHlpAPI.INSTANCE.GetNetworkParams(null, closeableIntByReference);
                if (n != 111) {
                    LOG.error("Failed to get network parameters buffer size. Error code: {}", (Object)n);
                    String[] stringArray = new String[]{};
                    return stringArray;
                }
                memory = new Memory(closeableIntByReference.getValue());
                n = IPHlpAPI.INSTANCE.GetNetworkParams(memory, closeableIntByReference);
                if (n == 0) break block16;
                LOG.error("Failed to get network parameters. Error code: {}", (Object)n);
                String[] stringArray = new String[]{};
                memory.close();
                return stringArray;
            }
            try {
                Object object;
                IPHlpAPI.FIXED_INFO fIXED_INFO = new IPHlpAPI.FIXED_INFO(memory);
                ArrayList<String[]> arrayList = new ArrayList<String[]>();
                IPHlpAPI.IP_ADDR_STRING iP_ADDR_STRING = fIXED_INFO.DnsServerList;
                while (iP_ADDR_STRING != null) {
                    object = Native.toString(iP_ADDR_STRING.IpAddress.String, StandardCharsets.US_ASCII);
                    int n = object.indexOf(0);
                    if (n != -1) {
                        object = object.substring(0, n);
                    }
                    arrayList.add((String[])object);
                    iP_ADDR_STRING = iP_ADDR_STRING.Next;
                }
                object = arrayList.toArray(new String[0]);
                memory.close();
                return object;
            }
            catch (Throwable throwable) {
                try {
                    memory.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Override
    public String getHostName() {
        try {
            return Kernel32Util.getComputerName();
        }
        catch (Win32Exception win32Exception) {
            return super.getHostName();
        }
    }

    @Override
    public String getIpv4DefaultGateway() {
        return WindowsNetworkParams.parseIpv4Route();
    }

    @Override
    public String getIpv6DefaultGateway() {
        return WindowsNetworkParams.parseIpv6Route();
    }

    private static String parseIpv4Route() {
        List<String> list = ExecutingCommand.runNative("route print -4 0.0.0.0");
        for (String string : list) {
            String[] stringArray = ParseUtil.whitespaces.split(string.trim());
            if (stringArray.length <= 2 || !"0.0.0.0".equals(stringArray[0])) continue;
            return stringArray[2];
        }
        return "";
    }

    private static String parseIpv6Route() {
        List<String> list = ExecutingCommand.runNative("route print -6 ::/0");
        for (String string : list) {
            String[] stringArray = ParseUtil.whitespaces.split(string.trim());
            if (stringArray.length <= 3 || !"::/0".equals(stringArray[2])) continue;
            return stringArray[3];
        }
        return "";
    }
}

