/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.mac;

import com.sun.jna.NativeLong;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.ByRef;
import oshi.jna.platform.mac.IOKit;
import oshi.jna.platform.mac.SystemB;
import oshi.util.ParseUtil;

@ThreadSafe
public final class SmcUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SmcUtil.class);
    private static final IOKit IO = IOKit.INSTANCE;
    private static Map<Integer, IOKit.SMCKeyDataKeyInfo> keyInfoCache = new ConcurrentHashMap<Integer, IOKit.SMCKeyDataKeyInfo>();
    private static final byte[] DATATYPE_SP78 = ParseUtil.asciiStringToByteArray("sp78", 5);
    private static final byte[] DATATYPE_FPE2 = ParseUtil.asciiStringToByteArray("fpe2", 5);
    private static final byte[] DATATYPE_FLT = ParseUtil.asciiStringToByteArray("flt ", 5);
    public static final String SMC_KEY_FAN_NUM = "FNum";
    public static final String SMC_KEY_FAN_SPEED = "F%dAc";
    public static final String SMC_KEY_CPU_TEMP = "TC0P";
    public static final String SMC_KEY_CPU_VOLTAGE = "VC0C";
    public static final byte SMC_CMD_READ_BYTES = 5;
    public static final byte SMC_CMD_READ_KEYINFO = 9;
    public static final int KERNEL_INDEX_SMC = 2;

    private SmcUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IOKit.IOConnect smcOpen() {
        IOKit.IOService iOService = IOKitUtil.getMatchingService("AppleSMC");
        if (iOService != null) {
            try (ByRef.CloseablePointerByReference closeablePointerByReference = new ByRef.CloseablePointerByReference();){
                int n = IO.IOServiceOpen(iOService, SystemB.INSTANCE.mach_task_self(), 0, closeablePointerByReference);
                if (n == 0) {
                    IOKit.IOConnect iOConnect = new IOKit.IOConnect(closeablePointerByReference.getValue());
                    return iOConnect;
                }
                if (!LOG.isErrorEnabled()) return null;
                LOG.error(String.format(Locale.ROOT, "Unable to open connection to AppleSMC service. Error: 0x%08x", n));
                return null;
            }
            finally {
                iOService.release();
            }
        } else {
            LOG.error("Unable to locate AppleSMC service");
        }
        return null;
    }

    public static int smcClose(IOKit.IOConnect iOConnect) {
        return IO.IOServiceClose(iOConnect);
    }

    public static double smcGetFloat(IOKit.IOConnect iOConnect, String string) {
        try (IOKit.SMCVal sMCVal = new IOKit.SMCVal();){
            int n = SmcUtil.smcReadKey(iOConnect, string, sMCVal);
            if (n == 0 && sMCVal.dataSize > 0) {
                if (Arrays.equals(sMCVal.dataType, DATATYPE_SP78) && sMCVal.dataSize == 2) {
                    double d = (double)sMCVal.bytes[0] + (double)sMCVal.bytes[1] / 256.0;
                    return d;
                }
                if (Arrays.equals(sMCVal.dataType, DATATYPE_FPE2) && sMCVal.dataSize == 2) {
                    double d = ParseUtil.byteArrayToFloat(sMCVal.bytes, sMCVal.dataSize, 2);
                    return d;
                }
                if (Arrays.equals(sMCVal.dataType, DATATYPE_FLT) && sMCVal.dataSize == 4) {
                    double d = ByteBuffer.wrap(sMCVal.bytes).order(ByteOrder.LITTLE_ENDIAN).getFloat();
                    return d;
                }
            }
        }
        return 0.0;
    }

    public static long smcGetLong(IOKit.IOConnect iOConnect, String string) {
        try (IOKit.SMCVal sMCVal = new IOKit.SMCVal();){
            int n = SmcUtil.smcReadKey(iOConnect, string, sMCVal);
            if (n == 0) {
                long l = ParseUtil.byteArrayToLong(sMCVal.bytes, sMCVal.dataSize);
                return l;
            }
        }
        return 0L;
    }

    public static int smcGetKeyInfo(IOKit.IOConnect iOConnect, IOKit.SMCKeyData sMCKeyData, IOKit.SMCKeyData sMCKeyData2) {
        if (keyInfoCache.containsKey(sMCKeyData.key)) {
            IOKit.SMCKeyDataKeyInfo sMCKeyDataKeyInfo = keyInfoCache.get(sMCKeyData.key);
            sMCKeyData2.keyInfo.dataSize = sMCKeyDataKeyInfo.dataSize;
            sMCKeyData2.keyInfo.dataType = sMCKeyDataKeyInfo.dataType;
            sMCKeyData2.keyInfo.dataAttributes = sMCKeyDataKeyInfo.dataAttributes;
        } else {
            sMCKeyData.data8 = (byte)9;
            int n = SmcUtil.smcCall(iOConnect, 2, sMCKeyData, sMCKeyData2);
            if (n != 0) {
                return n;
            }
            IOKit.SMCKeyDataKeyInfo sMCKeyDataKeyInfo = new IOKit.SMCKeyDataKeyInfo();
            sMCKeyDataKeyInfo.dataSize = sMCKeyData2.keyInfo.dataSize;
            sMCKeyDataKeyInfo.dataType = sMCKeyData2.keyInfo.dataType;
            sMCKeyDataKeyInfo.dataAttributes = sMCKeyData2.keyInfo.dataAttributes;
            keyInfoCache.put(sMCKeyData.key, sMCKeyDataKeyInfo);
        }
        return 0;
    }

    public static int smcReadKey(IOKit.IOConnect iOConnect, String string, IOKit.SMCVal sMCVal) {
        try (IOKit.SMCKeyData sMCKeyData = new IOKit.SMCKeyData();){
            int n;
            IOKit.SMCKeyData sMCKeyData2;
            block12: {
                sMCKeyData2 = new IOKit.SMCKeyData();
                try {
                    sMCKeyData.key = (int)ParseUtil.strToLong(string, 4);
                    n = SmcUtil.smcGetKeyInfo(iOConnect, sMCKeyData, sMCKeyData2);
                    if (n != 0) break block12;
                    sMCVal.dataSize = sMCKeyData2.keyInfo.dataSize;
                    sMCVal.dataType = ParseUtil.longToByteArray(sMCKeyData2.keyInfo.dataType, 4, 5);
                    sMCKeyData.keyInfo.dataSize = sMCVal.dataSize;
                    sMCKeyData.data8 = (byte)5;
                    n = SmcUtil.smcCall(iOConnect, 2, sMCKeyData, sMCKeyData2);
                    if (n != 0) break block12;
                    System.arraycopy(sMCKeyData2.bytes, 0, sMCVal.bytes, 0, sMCVal.bytes.length);
                    int n2 = 0;
                    sMCKeyData2.close();
                    return n2;
                }
                catch (Throwable throwable) {
                    try {
                        sMCKeyData2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            int n3 = n;
            sMCKeyData2.close();
            return n3;
        }
    }

    public static int smcCall(IOKit.IOConnect iOConnect, int n, IOKit.SMCKeyData sMCKeyData, IOKit.SMCKeyData sMCKeyData2) {
        try (ByRef.CloseableNativeLongByReference closeableNativeLongByReference = new ByRef.CloseableNativeLongByReference(new NativeLong((long)sMCKeyData2.size()));){
            int n2 = IO.IOConnectCallStructMethod(iOConnect, n, sMCKeyData, new NativeLong((long)sMCKeyData.size()), sMCKeyData2, closeableNativeLongByReference);
            return n2;
        }
    }
}

