/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.request.update;

import java.io.IOException;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.events.request.LauncherRequestEvent;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.websockets.WebSocketRequest;
import pro.gravit.launcher.core.api.features.CoreFeatureAPI$UpdateVariant;
import pro.gravit.launcher.mC4eVErSjUi5uE;
import pro.gravit.launcher.mC4ever4yGtj5y;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.SecurityHelper$DigestAlgorithm;

public final class LauncherRequest
extends Request<LauncherRequestEvent>
implements WebSocketRequest {
    private static final Logger logger = LoggerFactory.getLogger(LauncherRequest.class);
    public static final Path BINARY_PATH = IOHelper.getCodeSource(mC4eVErSjUi5uE.class);
    public static final boolean JAR_BINARY = IOHelper.hasExtension(BINARY_PATH, "jar");
    @mC4ever4yGtj5y
    public final String secureHash;
    @mC4ever4yGtj5y
    public final String secureSalt;
    @mC4ever4yGtj5y
    public byte[] digest;
    @mC4ever4yGtj5y
    public CoreFeatureAPI$UpdateVariant variant;

    public LauncherRequest() {
        Path path = IOHelper.getCodeSource(LauncherRequest.class);
        try {
            this.digest = SecurityHelper.digest(SecurityHelper$DigestAlgorithm.SHA512, path);
        }
        catch (IOException iOException) {
            logger.error("", iOException);
        }
        this.secureHash = mC4eVErSjUi5uE.mc4EvERdhSUc3c().mc4EVERfb3zOvw;
        this.secureSalt = mC4eVErSjUi5uE.mc4EvERdhSUc3c().mc4eVERvYdizz8;
        this.variant = LauncherRequest.getUpdateVariant();
    }

    public static CoreFeatureAPI$UpdateVariant getUpdateVariant() {
        if (JAR_BINARY) {
            return CoreFeatureAPI$UpdateVariant.JAR;
        }
        switch (JVMHelper.OS_TYPE) {
            case MUSTDIE: {
                switch (JVMHelper.ARCH_TYPE) {
                    case X86: {
                        return CoreFeatureAPI$UpdateVariant.EXE_WINDOWS_X86;
                    }
                    case X86_64: {
                        return CoreFeatureAPI$UpdateVariant.EXE_WINDOWS_X86_64;
                    }
                    case ARM64: {
                        return CoreFeatureAPI$UpdateVariant.EXE_WINDOWS_ARM64;
                    }
                }
                return CoreFeatureAPI$UpdateVariant.JAR;
            }
            case LINUX: {
                switch (JVMHelper.ARCH_TYPE) {
                    case X86: {
                        return CoreFeatureAPI$UpdateVariant.LINUX_X86;
                    }
                    case X86_64: {
                        return CoreFeatureAPI$UpdateVariant.LINUX_X86_64;
                    }
                    case ARM64: {
                        return CoreFeatureAPI$UpdateVariant.LINUX_ARM64;
                    }
                    case ARM32: {
                        return CoreFeatureAPI$UpdateVariant.LINUX_ARM32;
                    }
                }
                return CoreFeatureAPI$UpdateVariant.JAR;
            }
            case MACOSX: {
                switch (JVMHelper.ARCH_TYPE) {
                    case X86_64: {
                        return CoreFeatureAPI$UpdateVariant.MACOS_X86_64;
                    }
                    case ARM64: {
                        return CoreFeatureAPI$UpdateVariant.MACOS_ARM64;
                    }
                }
                return CoreFeatureAPI$UpdateVariant.JAR;
            }
        }
        return CoreFeatureAPI$UpdateVariant.JAR;
    }

    @Override
    public LauncherRequestEvent requestDo(RequestService requestService) {
        return (LauncherRequestEvent)super.request(requestService);
    }

    @Override
    public String getType() {
        return "launcher";
    }
}

