/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jline.reader.Candidate;
import pro.gravit.utils.command.CommandException;
import pro.gravit.utils.command.CommandHandler;
import pro.gravit.utils.helper.VerifyHelper;

public abstract class Command {
    public final Map<String, Command> childCommands;

    public Command() {
        this.childCommands = new HashMap<String, Command>();
    }

    public Command(Map<String, Command> map) {
        this.childCommands = map;
    }

    protected static String parseUsername(String string) {
        try {
            return VerifyHelper.verifyUsername(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CommandException(illegalArgumentException.getMessage());
        }
    }

    protected static UUID parseUUID(String string) {
        try {
            return UUID.fromString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CommandException(String.format("Invalid UUID: '%s'", string));
        }
    }

    public abstract String getArgsDescription();

    public abstract String getUsageDescription();

    public Candidate buildCandidate(CommandHandler.Category category, String string) {
        return new Candidate(string);
    }

    public List<Candidate> complete(List<String> list, int n, String string) {
        if (n == 0) {
            ArrayList<Candidate> arrayList = new ArrayList<Candidate>();
            this.childCommands.forEach((string2, command) -> {
                if (string2.startsWith(string)) {
                    arrayList.add(new Candidate(string2));
                }
            });
            return arrayList;
        }
        Command command2 = this.childCommands.get(list.get(0));
        if (command2 == null) {
            return new ArrayList<Candidate>();
        }
        return command2.complete(list.subList(1, list.size()), n - 1, string);
    }

    public void invokeSubcommands(String ... stringArray) {
        this.verifyArgs(stringArray, 1);
        Command command = this.childCommands.get(stringArray[0]);
        if (command == null) {
            throw new CommandException(String.format("Unknown sub command: '%s'", stringArray[0]));
        }
        command.invoke(Arrays.copyOfRange(stringArray, 1, stringArray.length));
    }

    public abstract void invoke(String ... var1);

    protected final void verifyArgs(String[] stringArray, int n) {
        if (stringArray.length < n) {
            throw new CommandException("Command usage: " + this.getArgsDescription());
        }
    }
}

