/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.command.basic;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.CommandException;
import pro.gravit.utils.command.CommandHandler;
import pro.gravit.utils.command.CommandHandler$Category;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.LogHelper$Level;

public final class HelpCommand
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(HelpCommand.class);
    private final CommandHandler handler;

    public HelpCommand(CommandHandler commandHandler) {
        this.handler = commandHandler;
    }

    public static void printCommand(String string, Command command) {
        String string2 = command.getArgsDescription();
        Supplier<String> supplier = () -> String.format("%s %s - %s", string, string2 == null ? "[nothing]" : string2, command.getUsageDescription());
        Supplier<String> supplier2 = () -> {
            Ansi ansi = new Ansi();
            ansi.fgBright(Ansi.Color.GREEN);
            ansi.a(string + " ");
            ansi.fgBright(Ansi.Color.CYAN);
            ansi.a(string2 == null ? "[nothing]" : string2);
            ansi.reset();
            ansi.a(" - ");
            ansi.fgBright(Ansi.Color.YELLOW);
            ansi.a(command.getUsageDescription());
            ansi.reset();
            return ansi.toString();
        };
        LogHelper.logJAnsi(LogHelper$Level.INFO, supplier, supplier2, true);
    }

    public static void printSubCommandsHelp(String string, Command command2) {
        command2.childCommands.forEach((string2, command) -> HelpCommand.printCommand(string.concat(" ").concat((String)string2), command));
    }

    public static void printSubCommandsHelp(String string, String[] stringArray, Command command) {
        if (stringArray.length == 0) {
            HelpCommand.printSubCommandsHelp(string, command);
        } else {
            Command command2 = command.childCommands.get(stringArray[0]);
            if (command2 == null) {
                throw new CommandException(String.format("Unknown sub command: '%s'", stringArray[0]));
            }
            HelpCommand.printSubCommandsHelp(string.concat(" ").concat(stringArray[0]), Arrays.copyOfRange(stringArray, 1, stringArray.length), command2);
        }
    }

    private static void printCategory(String string, String string2) {
        if (string2 != null) {
            logger.info("Category: {} - {}", (Object)string, (Object)string2);
        } else {
            logger.info("Category: {}", (Object)string);
        }
    }

    @Override
    public String getArgsDescription() {
        return "[command name]";
    }

    @Override
    public String getUsageDescription() {
        return "Print command usage";
    }

    @Override
    public void invoke(String ... stringArray) {
        if (stringArray.length < 1) {
            this.printCommands();
            return;
        }
        if (stringArray.length == 1) {
            this.printCommand(stringArray[0]);
        }
        HelpCommand.printSubCommandsHelp(stringArray[0], Arrays.copyOfRange(stringArray, 1, stringArray.length), this.handler.lookup(stringArray[0]));
    }

    private void printCommand(String string) {
        HelpCommand.printCommand(string, this.handler.lookup(string));
    }

    private void printCommands() {
        for (CommandHandler$Category object : this.handler.getCategories()) {
            HelpCommand.printCategory(object.name, object.description);
            for (Map.Entry<String, Command> entry : object.category.commandsMap().entrySet()) {
                HelpCommand.printCommand(entry.getKey(), entry.getValue());
            }
        }
        HelpCommand.printCategory("Base", null);
        for (Map.Entry entry : this.handler.getBaseCategory().commandsMap().entrySet()) {
            HelpCommand.printCommand((String)entry.getKey(), (Command)entry.getValue());
        }
    }
}

