/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HexFormat;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.utils.helper.IOHelper$1;
import pro.gravit.utils.helper.IOHelper$2;
import pro.gravit.utils.helper.IOHelper$DeleteDirVisitor;
import pro.gravit.utils.helper.IOHelper$MoveFileVisitor;
import pro.gravit.utils.helper.IOHelper$SkipHiddenVisitor;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JVMHelper$OS;
import pro.gravit.utils.helper.VerifyHelper;

public final class IOHelper {
    private static final Logger logger = LoggerFactory.getLogger(IOHelper.class);
    public static final long MB32 = 0x2000000L;
    public static final Charset UNICODE_CHARSET = StandardCharsets.UTF_8;
    public static final Charset ASCII_CHARSET = StandardCharsets.US_ASCII;
    public static final int MAX_BATCH_SIZE = 128;
    public static final int SOCKET_TIMEOUT = VerifyHelper.verifyInt(Integer.parseUnsignedInt(System.getProperty("launcher.socketTimeout", Integer.toString(30000))), VerifyHelper.POSITIVE, "launcher.socketTimeout can't be <= 0");
    public static final int HTTP_TIMEOUT = VerifyHelper.verifyInt(Integer.parseUnsignedInt(System.getProperty("launcher.httpTimeout", Integer.toString(5000))), VerifyHelper.POSITIVE, "launcher.httpTimeout can't be <= 0");
    public static final int BUFFER_SIZE = VerifyHelper.verifyInt(Integer.parseUnsignedInt(System.getProperty("launcher.bufferSize", Integer.toString(4096))), VerifyHelper.POSITIVE, "launcher.bufferSize can't be <= 0");
    public static final String CROSS_SEPARATOR = "/";
    public static final FileSystem FS = FileSystems.getDefault();
    public static final String PLATFORM_SEPARATOR = FS.getSeparator();
    private static final Pattern PLATFORM_SEPARATOR_PATTERN = Pattern.compile(PLATFORM_SEPARATOR, 16);
    public static final boolean POSIX = FS.supportedFileAttributeViews().contains("posix") || FS.supportedFileAttributeViews().contains("Posix");
    public static final Path JVM_DIR = Paths.get(System.getProperty("java.home"), new String[0]);
    public static final Path HOME_DIR = Paths.get(System.getProperty("user.home"), new String[0]);
    public static final Path WORKING_DIR = Paths.get(System.getProperty("user.dir"), new String[0]);
    public static final String USER_AGENT = System.getProperty("launcher.userAgentDefault", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
    private static final OpenOption[] READ_OPTIONS = new OpenOption[]{StandardOpenOption.READ};
    private static final OpenOption[] WRITE_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final OpenOption[] APPEND_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND};
    private static final LinkOption[] LINK_OPTIONS = new LinkOption[0];
    private static final CopyOption[] COPY_OPTIONS = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
    private static final Set<FileVisitOption> WALK_OPTIONS = Collections.singleton(FileVisitOption.FOLLOW_LINKS);
    private static final Pattern CROSS_SEPARATOR_PATTERN = Pattern.compile("/", 16);

    private IOHelper() {
    }

    public static void close(AutoCloseable autoCloseable) {
        try {
            autoCloseable.close();
        }
        catch (Exception exception) {
            logger.error("", exception);
        }
    }

    public static void close(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(OutputStream outputStream) {
        try {
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Manifest getManifest(Class<?> clazz) {
        Manifest manifest;
        Path path = IOHelper.getCodeSource(clazz);
        JarFile jarFile = new JarFile(path.toFile());
        try {
            manifest = jarFile.getManifest();
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        jarFile.close();
        return manifest;
    }

    public static URL convertToURL(String string) {
        try {
            return new URI(string).toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new IllegalArgumentException("Invalid URL", exception);
        }
    }

    public static void copy(Path path, Path path2) {
        IOHelper.createParentDirs(path2);
        Files.copy(path, path2, COPY_OPTIONS);
    }

    public static void createParentDirs(Path path) {
        Path path2 = path.getParent();
        if (path2 != null && !IOHelper.isDir(path2)) {
            Files.createDirectories(path2, new FileAttribute[0]);
        }
    }

    public static String decode(byte[] byArray) {
        return new String(byArray, UNICODE_CHARSET);
    }

    public static String decodeASCII(byte[] byArray) {
        return new String(byArray, ASCII_CHARSET);
    }

    public static void deleteDir(Path path, boolean bl) {
        IOHelper.walk(path, new IOHelper$DeleteDirVisitor(path, bl), true);
    }

    public static byte[] encode(String string) {
        return string.getBytes(UNICODE_CHARSET);
    }

    public static byte[] encodeASCII(String string) {
        return string.getBytes(ASCII_CHARSET);
    }

    public static boolean exists(Path path) {
        return Files.exists(path, LINK_OPTIONS);
    }

    public static Path getCodeSource(Class<?> clazz) {
        return Paths.get(IOHelper.toURI(clazz.getProtectionDomain().getCodeSource().getLocation()));
    }

    public static String getFileName(Path path) {
        return path.getFileName().toString();
    }

    public static String getIP(SocketAddress socketAddress) {
        return ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
    }

    public static Path getRoot() {
        return switch (JVMHelper.OS_TYPE) {
            default -> throw new MatchException(null, null);
            case JVMHelper$OS.MUSTDIE -> {
                String var0 = System.getenv("SystemDrive").concat("\\");
                yield Paths.get(var0, new String[0]);
            }
            case JVMHelper$OS.LINUX, JVMHelper$OS.MACOSX -> Paths.get(CROSS_SEPARATOR, new String[0]);
        };
    }

    public static byte[] getResourceBytes(String string) {
        return IOHelper.read(IOHelper.getResourceURL(string));
    }

    public static URL getResourceURL(String string) {
        URL uRL = IOHelper.class.getResource(CROSS_SEPARATOR + string);
        if (uRL == null) {
            throw new NoSuchFileException(string);
        }
        return uRL;
    }

    public static boolean hasExtension(Path path, String string) {
        return IOHelper.getFileName(path).endsWith("." + string);
    }

    public static boolean isDir(Path path) {
        return Files.isDirectory(path, LINK_OPTIONS);
    }

    public static boolean isEmpty(Path path) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            boolean bl = !directoryStream.iterator().hasNext();
            return bl;
        }
    }

    public static boolean isFile(Path path) {
        return Files.isRegularFile(path, LINK_OPTIONS);
    }

    public static boolean isValidFileName(String string) {
        return !string.equals(".") && !string.equals("..") && string.chars().noneMatch(n -> n == 47 || n == 92) && IOHelper.isValidPath(string);
    }

    public static boolean isValidPath(String string) {
        try {
            IOHelper.toPath(string);
            return true;
        }
        catch (InvalidPathException invalidPathException) {
            return false;
        }
    }

    public static boolean isValidTextureBounds(int n, int n2, boolean bl) {
        return n % 64 == 0 && (n2 << 1 == n || !bl && n2 == n) && n <= 1024 || bl && n % 22 == 0 && n2 % 17 == 0 && n / 22 == n2 / 17;
    }

    public static void move(Path path, Path path2) {
        IOHelper.walk(path, new IOHelper$MoveFileVisitor(path, path2), true);
    }

    public static byte[] newBuffer() {
        return new byte[BUFFER_SIZE];
    }

    public static ByteArrayOutputStream newByteArrayOutput() {
        return new ByteArrayOutputStream();
    }

    public static char[] newCharBuffer() {
        return new char[BUFFER_SIZE];
    }

    public static URLConnection newConnection(URL uRL) {
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            uRLConnection.setReadTimeout(HTTP_TIMEOUT);
            uRLConnection.setConnectTimeout(HTTP_TIMEOUT);
            uRLConnection.addRequestProperty("User-Agent", USER_AGENT);
        } else {
            uRLConnection.setUseCaches(false);
        }
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(false);
        return uRLConnection;
    }

    public static HttpURLConnection newConnectionPost(URL uRL) {
        HttpURLConnection httpURLConnection = (HttpURLConnection)IOHelper.newConnection(uRL);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        return httpURLConnection;
    }

    public static Deflater newDeflater() {
        Deflater deflater = new Deflater(-1, true);
        deflater.setStrategy(0);
        return deflater;
    }

    public static Inflater newInflater() {
        return new Inflater(true);
    }

    public static InputStream newInput(Path path) {
        return Files.newInputStream(path, READ_OPTIONS);
    }

    public static InputStream newBufferedInput(Path path) {
        return new BufferedInputStream(Files.newInputStream(path, READ_OPTIONS));
    }

    public static InputStream newInput(URL uRL) {
        return IOHelper.newConnection(uRL).getInputStream();
    }

    public static BufferedInputStream newBufferedInput(URL uRL) {
        return new BufferedInputStream(IOHelper.newConnection(uRL).getInputStream());
    }

    public static OutputStream newOutput(Path path) {
        return IOHelper.newOutput(path, false);
    }

    public static OutputStream newBufferedOutput(Path path) {
        return IOHelper.newBufferedOutput(path, false);
    }

    public static OutputStream newOutput(Path path, boolean bl) {
        IOHelper.createParentDirs(path);
        return Files.newOutputStream(path, bl ? APPEND_OPTIONS : WRITE_OPTIONS);
    }

    public static OutputStream newBufferedOutput(Path path, boolean bl) {
        IOHelper.createParentDirs(path);
        return new BufferedOutputStream(Files.newOutputStream(path, bl ? APPEND_OPTIONS : WRITE_OPTIONS));
    }

    public static BufferedReader newReader(InputStream inputStream) {
        return IOHelper.newReader(inputStream, UNICODE_CHARSET);
    }

    public static BufferedReader newReader(InputStream inputStream, Charset charset) {
        return new BufferedReader(new InputStreamReader(inputStream, charset));
    }

    public static BufferedReader newReader(Path path) {
        return Files.newBufferedReader(path, UNICODE_CHARSET);
    }

    public static BufferedReader newReader(URL uRL) {
        URLConnection uRLConnection = IOHelper.newConnection(uRL);
        String string = uRLConnection.getContentEncoding();
        return IOHelper.newReader(uRLConnection.getInputStream(), string == null ? UNICODE_CHARSET : Charset.forName(string));
    }

    public static Socket newSocket() {
        Socket socket = new Socket();
        IOHelper.setSocketFlags(socket);
        return socket;
    }

    public static BufferedWriter newWriter(FileDescriptor fileDescriptor) {
        return IOHelper.newWriter(new FileOutputStream(fileDescriptor));
    }

    public static BufferedWriter newWriter(OutputStream outputStream) {
        return new BufferedWriter(new OutputStreamWriter(outputStream, UNICODE_CHARSET));
    }

    public static BufferedWriter newWriter(Path path) {
        return IOHelper.newWriter(path, false);
    }

    public static BufferedWriter newWriter(Path path, boolean bl) {
        IOHelper.createParentDirs(path);
        return Files.newBufferedWriter(path, UNICODE_CHARSET, bl ? APPEND_OPTIONS : WRITE_OPTIONS);
    }

    public static ZipEntry newZipEntry(String string) {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(0L);
        return zipEntry;
    }

    public static ZipEntry newZipEntry(ZipEntry zipEntry) {
        return IOHelper.newZipEntry(zipEntry.getName());
    }

    public static ZipInputStream newZipInput(InputStream inputStream) {
        return new ZipInputStream(inputStream, UNICODE_CHARSET);
    }

    public static ZipInputStream newZipInput(Path path) {
        return IOHelper.newZipInput(IOHelper.newInput(path));
    }

    public static ZipInputStream newZipInput(URL uRL) {
        return IOHelper.newZipInput(IOHelper.newInput(uRL));
    }

    public static byte[] read(InputStream inputStream) {
        try (ByteArrayOutputStream byteArrayOutputStream = IOHelper.newByteArrayOutput();){
            IOHelper.transfer(inputStream, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static void read(InputStream inputStream, byte[] byArray) {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            n = inputStream.read(byArray, i, byArray.length - i);
            if (n >= 0) continue;
            throw new EOFException(String.format("%d bytes remaining", byArray.length - i));
        }
    }

    public static byte[] read(Path path) {
        long l = IOHelper.readAttributes(path).size();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("File too big");
        }
        byte[] byArray = new byte[(int)l];
        try (InputStream inputStream = IOHelper.newInput(path);){
            IOHelper.read(inputStream, byArray);
        }
        return byArray;
    }

    public static byte[] read(URL uRL) {
        try (InputStream inputStream = IOHelper.newInput(uRL);){
            byte[] byArray = IOHelper.read(inputStream);
            return byArray;
        }
    }

    public static BasicFileAttributes readAttributes(Path path) {
        return Files.readAttributes(path, BasicFileAttributes.class, LINK_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readTexture(Object object, boolean bl) {
        ImageReader imageReader = ImageIO.getImageReadersByMIMEType("image/png").next();
        try {
            imageReader.setInput(ImageIO.createImageInputStream(object), false, false);
            int n = imageReader.getWidth(0);
            int n2 = imageReader.getHeight(0);
            if (!IOHelper.isValidTextureBounds(n, n2, bl)) {
                throw new IOException(String.format("Invalid texture bounds: %dx%d", n, n2));
            }
            imageReader.read(0);
        }
        finally {
            imageReader.dispose();
        }
    }

    public static String request(URL uRL) {
        return IOHelper.decode(IOHelper.read(uRL)).trim();
    }

    public static InetSocketAddress resolve(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress.isUnresolved()) {
            return new InetSocketAddress(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
        }
        return inetSocketAddress;
    }

    public static Path resolveIncremental(Path path, String string, String string2) {
        Path path2;
        Path path3 = path.resolve(string + "." + string2);
        if (!IOHelper.exists(path3)) {
            return path3;
        }
        int n = 1;
        while (IOHelper.exists(path2 = path.resolve(String.format("%s (%d).%s", string, n, string2)))) {
            ++n;
        }
        return path2;
    }

    public static Path resolveJavaBin(Path path) {
        return IOHelper.resolveJavaBin(path, false);
    }

    public static Path resolveJavaBin(Path path, boolean bl) {
        Path path2;
        Path path3 = (path == null ? JVM_DIR : path).resolve("bin");
        if (!bl) {
            // empty if block
        }
        if (IOHelper.isFile(path2 = path3.resolve("java.exe"))) {
            return path2;
        }
        Path path4 = path3.resolve("java");
        if (IOHelper.isFile(path4)) {
            return path4;
        }
        throw new RuntimeException("Java binary wasn't found");
    }

    public static void setSocketFlags(Socket socket) {
        socket.setKeepAlive(false);
        socket.setTcpNoDelay(false);
        socket.setReuseAddress(true);
        socket.setSoTimeout(SOCKET_TIMEOUT);
        try {
            socket.setTrafficClass(28);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        socket.setPerformancePreferences(1, 0, 2);
    }

    public static String toAbsPathString(Path path) {
        return IOHelper.toAbsPath(path).toFile().getAbsolutePath();
    }

    public static Path toAbsPath(Path path) {
        return path.normalize().toAbsolutePath();
    }

    public static byte[] toByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
        IOHelper.transfer(inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Path toPath(String string) {
        return Paths.get(CROSS_SEPARATOR_PATTERN.matcher(string).replaceAll(Matcher.quoteReplacement(PLATFORM_SEPARATOR)), new String[0]);
    }

    public static String toString(Path path) {
        return PLATFORM_SEPARATOR_PATTERN.matcher(path.toString()).replaceAll(Matcher.quoteReplacement(CROSS_SEPARATOR));
    }

    public static URI toURI(URL uRL) {
        try {
            return uRL.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    public static URL toURL(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new InternalError(malformedURLException);
        }
    }

    public static void transfer(byte[] byArray, Path path, boolean bl) {
        try (OutputStream outputStream = IOHelper.newOutput(path, bl);){
            outputStream.write(byArray);
        }
    }

    public static long transfer(InputStream inputStream, OutputStream outputStream) {
        long l = 0L;
        byte[] byArray = IOHelper.newBuffer();
        int n = inputStream.read(byArray);
        while (n >= 0) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
            n = inputStream.read(byArray);
        }
        return l;
    }

    public static void transfer(InputStream inputStream, Path path) {
        IOHelper.transfer(inputStream, path, false);
    }

    public static long transfer(InputStream inputStream, Path path, boolean bl) {
        try (OutputStream outputStream = IOHelper.newOutput(path, bl);){
            long l = IOHelper.transfer(inputStream, outputStream);
            return l;
        }
    }

    public static void transfer(Path path, OutputStream outputStream) {
        try (InputStream inputStream = IOHelper.newInput(path);){
            IOHelper.transfer(inputStream, outputStream);
        }
    }

    public static String urlDecode(String string) {
        return URLDecoder.decode(string, UNICODE_CHARSET);
    }

    public static String urlEncode(String string) {
        return URLEncoder.encode(string, UNICODE_CHARSET);
    }

    public static String urlDecodeStrict(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c != '%') {
                stringBuilder.append(c);
                continue;
            }
            if (i + 2 >= cArray.length) {
                return null;
            }
            CharBuffer charBuffer = UNICODE_CHARSET.decode(ByteBuffer.wrap(HexFormat.of().parseHex(CharBuffer.wrap(cArray, i + 1, 2))));
            stringBuilder.append(charBuffer);
            i += 2;
        }
        return stringBuilder.toString();
    }

    public static String getPathFromUrlFragment(String string) {
        return string.indexOf(63) < 0 ? string : string.substring(0, string.indexOf(63));
    }

    public static String verifyFileName(String string) {
        return VerifyHelper.verify(string, IOHelper::isValidFileName, String.format("Invalid file name: '%s'", string));
    }

    public static int verifyLength(int n, int n2) {
        if (n < 0 || n2 < 0 && n != -n2 || n2 > 0 && n > n2) {
            throw new IOException("Illegal length: " + n);
        }
        return n;
    }

    public static BufferedImage verifyTexture(BufferedImage bufferedImage2, boolean bl) {
        return VerifyHelper.verify(bufferedImage2, bufferedImage -> IOHelper.isValidTextureBounds(bufferedImage.getWidth(), bufferedImage.getHeight(), bl), String.format("Invalid texture bounds: %dx%d", bufferedImage2.getWidth(), bufferedImage2.getHeight()));
    }

    public static String verifyURL(String string) {
        try {
            new URI(string);
            return string;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Invalid URL", uRISyntaxException);
        }
    }

    public static void walk(Path path, FileVisitor<Path> iOHelper$SkipHiddenVisitor, boolean bl) {
        Files.walkFileTree(path, WALK_OPTIONS, Integer.MAX_VALUE, bl ? iOHelper$SkipHiddenVisitor : new IOHelper$SkipHiddenVisitor(iOHelper$SkipHiddenVisitor));
    }

    public static void write(Path path, byte[] byArray) {
        IOHelper.createParentDirs(path);
        Files.write(path, byArray, WRITE_OPTIONS);
    }

    public static InputStream nonClosing(InputStream inputStream) {
        return new IOHelper$1(inputStream);
    }

    public static OutputStream nonClosing(OutputStream outputStream) {
        return new IOHelper$2(outputStream);
    }
}

