/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.logging;

import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.utils.helper.FormatHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.LogHelper$Level;
import pro.gravit.utils.helper.LogHelper$Output;
import pro.gravit.utils.helper.LogHelper$OutputEnity;
import pro.gravit.utils.helper.LogHelper$OutputTypes;
import pro.gravit.utils.logging.LogHelperAppender;
import pro.gravit.utils.logging.SimpleLogHelperImpl$JAnsiOutput;
import pro.gravit.utils.logging.SimpleLogHelperImpl$WriterOutput;

public class SimpleLogHelperImpl
implements LogHelperAppender {
    private static final Logger logger = LoggerFactory.getLogger(SimpleLogHelperImpl.class);
    private static final AtomicBoolean DEBUG_ENABLED = new AtomicBoolean(Boolean.getBoolean("launcher.debug"));
    private static final AtomicBoolean STACKTRACE_ENABLED = new AtomicBoolean(Boolean.getBoolean("launcher.stacktrace"));
    private static final AtomicBoolean DEV_ENABLED = new AtomicBoolean(Boolean.getBoolean("launcher.dev"));
    public final boolean JANSI;
    private final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm:ss", Locale.US);
    private final Set<LogHelper$OutputEnity> OUTPUTS = Collections.newSetFromMap(new ConcurrentHashMap(2));

    public SimpleLogHelperImpl() {
        boolean bl;
        try {
            if (Boolean.getBoolean("launcher.noJAnsi")) {
                bl = false;
            } else {
                Class.forName("org.fusesource.jansi.Ansi");
                AnsiConsole.systemInstall();
                bl = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        this.JANSI = bl;
        LogHelper$OutputEnity logHelper$OutputEnity = new LogHelper$OutputEnity(System.out::println, this.JANSI ? LogHelper$OutputTypes.JANSI : LogHelper$OutputTypes.PLAIN);
        this.addOutput(logHelper$OutputEnity);
        String string = System.getProperty("launcher.logFile");
        if (string != null) {
            try {
                this.addOutput(IOHelper.toPath(string));
            }
            catch (IOException iOException) {
                LogHelper.error(iOException);
            }
        }
    }

    public void addOutput(Writer writer) {
        this.addOutput(new SimpleLogHelperImpl$WriterOutput(writer), LogHelper$OutputTypes.PLAIN);
    }

    @Override
    public void log(LogHelper$Level logHelper$Level, String string, boolean bl) {
        String string2 = this.DATE_TIME_FORMATTER.format(LocalDateTime.now());
        String string3 = null;
        String string4 = null;
        for (LogHelper$OutputEnity logHelper$OutputEnity : this.OUTPUTS) {
            if (logHelper$OutputEnity.type == LogHelper$OutputTypes.JANSI && this.JANSI) {
                if (string3 != null) {
                    logHelper$OutputEnity.output.println(string3);
                    continue;
                }
                string3 = this.ansiFormatLog(logHelper$Level, string2, string, bl);
                logHelper$OutputEnity.output.println(string3);
                continue;
            }
            if (string4 != null) {
                logHelper$OutputEnity.output.println(string4);
                continue;
            }
            string4 = this.formatLog(logHelper$Level, string, string2, bl);
            logHelper$OutputEnity.output.println(string4);
        }
    }

    @Override
    public void logJAnsi(LogHelper$Level logHelper$Level, Supplier<String> supplier, Supplier<String> supplier2, boolean bl) {
        if (this.JANSI) {
            this.log(logHelper$Level, supplier2.get(), bl);
        } else {
            this.log(logHelper$Level, supplier.get(), bl);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return DEBUG_ENABLED.get();
    }

    @Override
    public void setDebugEnabled(boolean bl) {
        DEBUG_ENABLED.set(bl);
    }

    @Override
    public boolean isStacktraceEnabled() {
        return STACKTRACE_ENABLED.get();
    }

    @Override
    public void setStacktraceEnabled(boolean bl) {
        STACKTRACE_ENABLED.set(bl);
    }

    @Override
    public boolean isDevEnabled() {
        return DEV_ENABLED.get();
    }

    @Override
    public void setDevEnabled(boolean bl) {
        DEV_ENABLED.set(bl);
    }

    @Override
    public void addOutput(LogHelper$OutputEnity logHelper$OutputEnity) {
        this.OUTPUTS.add(logHelper$OutputEnity);
    }

    @Override
    public boolean removeOutput(LogHelper$OutputEnity logHelper$OutputEnity) {
        return this.OUTPUTS.remove(logHelper$OutputEnity);
    }

    public void rawLog(Supplier<String> supplier, Supplier<String> supplier2) {
        String string = null;
        String string2 = null;
        for (LogHelper$OutputEnity logHelper$OutputEnity : this.OUTPUTS) {
            if (logHelper$OutputEnity.type == LogHelper$OutputTypes.JANSI && this.JANSI) {
                if (string != null) {
                    logHelper$OutputEnity.output.println(string);
                    continue;
                }
                string = supplier2.get();
                logHelper$OutputEnity.output.println(string);
                continue;
            }
            if (string2 != null) {
                logHelper$OutputEnity.output.println(string2);
                continue;
            }
            string2 = supplier.get();
            logHelper$OutputEnity.output.println(string2);
        }
    }

    public void addOutput(LogHelper$Output logHelper$Output, LogHelper$OutputTypes logHelper$OutputTypes) {
        this.addOutput(new LogHelper$OutputEnity(Objects.requireNonNull(logHelper$Output, "output"), logHelper$OutputTypes));
    }

    public void addOutput(Path path) {
        if (this.JANSI) {
            this.addOutput(new SimpleLogHelperImpl$JAnsiOutput(IOHelper.newOutput(path, true)), LogHelper$OutputTypes.JANSI);
        } else {
            this.addOutput(IOHelper.newWriter(path, true));
        }
    }

    private String ansiFormatLog(LogHelper$Level logHelper$Level, String string, String string2, boolean bl) {
        Ansi ansi = FormatHelper.rawAnsiFormat(logHelper$Level, string, bl);
        ansi.a(string2);
        return ansi.reset().toString();
    }

    private String formatLog(LogHelper$Level logHelper$Level, String string, String string2, boolean bl) {
        return FormatHelper.rawFormat(logHelper$Level, string2, bl) + string;
    }

    @Override
    public void printVersion(String string) {
        String string2 = null;
        String string3 = null;
        for (LogHelper$OutputEnity logHelper$OutputEnity : this.OUTPUTS) {
            if (logHelper$OutputEnity.type == LogHelper$OutputTypes.JANSI && this.JANSI) {
                if (string2 != null) {
                    logHelper$OutputEnity.output.println(string2);
                    continue;
                }
                string2 = FormatHelper.ansiFormatVersion(string);
                logHelper$OutputEnity.output.println(string2);
                continue;
            }
            if (string3 != null) {
                logHelper$OutputEnity.output.println(string3);
                continue;
            }
            string3 = FormatHelper.formatVersion(string);
            logHelper$OutputEnity.output.println(string3);
        }
    }

    @Override
    public void printLicense(String string) {
        String string2 = null;
        String string3 = null;
        for (LogHelper$OutputEnity logHelper$OutputEnity : this.OUTPUTS) {
            if (logHelper$OutputEnity.type == LogHelper$OutputTypes.JANSI && this.JANSI) {
                if (string2 != null) {
                    logHelper$OutputEnity.output.println(string2);
                    continue;
                }
                string2 = FormatHelper.ansiFormatLicense(string);
                logHelper$OutputEnity.output.println(string2);
                continue;
            }
            if (string3 != null) {
                logHelper$OutputEnity.output.println(string3);
                continue;
            }
            string3 = FormatHelper.formatLicense(string);
            logHelper$OutputEnity.output.println(string3);
        }
    }
}

