/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;

public class KnownPacksManager {
    private final PackRepository repository = ServerPacksSource.createVanillaTrustedRepository();
    private final Map<KnownPack, String> knownPackToId;

    public KnownPacksManager() {
        this.repository.reload();
        ImmutableMap.Builder $$0 = ImmutableMap.builder();
        this.repository.getAvailablePacks().forEach(p_326227_ -> {
            PackLocationInfo $$2 = p_326227_.location();
            $$2.knownPackInfo().ifPresent(p_326321_ -> $$0.put(p_326321_, (Object)$$2.id()));
        });
        this.knownPackToId = $$0.build();
    }

    public List<KnownPack> trySelectingPacks(List<KnownPack> p_326056_) {
        ArrayList<KnownPack> $$1 = new ArrayList<KnownPack>(p_326056_.size());
        ArrayList<String> $$2 = new ArrayList<String>(p_326056_.size());
        for (KnownPack $$3 : p_326056_) {
            String $$4 = this.knownPackToId.get($$3);
            if ($$4 == null) continue;
            $$2.add($$4);
            $$1.add($$3);
        }
        this.repository.setSelected($$2);
        return $$1;
    }

    public CloseableResourceManager createResourceManager() {
        List<PackResources> $$0 = this.repository.openAllSelected();
        return new MultiPackResourceManager(PackType.SERVER_DATA, $$0);
    }
}

