/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.CreeperPowerLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;

public class CreeperRenderer
extends MobRenderer<Creeper, CreeperModel<Creeper>> {
    private static final ResourceLocation CREEPER_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/creeper/creeper.png");

    public CreeperRenderer(EntityRendererProvider.Context p_173958_) {
        super(p_173958_, new CreeperModel(p_173958_.bakeLayer(ModelLayers.CREEPER)), 0.5f);
        this.addLayer(new CreeperPowerLayer(this, p_173958_.getModelSet()));
    }

    @Override
    protected void scale(Creeper p_114046_, PoseStack p_114047_, float p_114048_) {
        float $$3 = p_114046_.getSwelling(p_114048_);
        float $$4 = 1.0f + Mth.sin($$3 * 100.0f) * $$3 * 0.01f;
        $$3 = Mth.clamp($$3, 0.0f, 1.0f);
        $$3 *= $$3;
        $$3 *= $$3;
        float $$5 = (1.0f + $$3 * 0.4f) * $$4;
        float $$6 = (1.0f + $$3 * 0.1f) / $$4;
        p_114047_.scale($$5, $$6, $$5);
    }

    @Override
    protected float getWhiteOverlayProgress(Creeper p_114043_, float p_114044_) {
        float $$2 = p_114043_.getSwelling(p_114044_);
        if ((int)($$2 * 10.0f) % 2 == 0) {
            return 0.0f;
        }
        return Mth.clamp($$2, 0.5f, 1.0f);
    }

    @Override
    public ResourceLocation getTextureLocation(Creeper p_114041_) {
        return CREEPER_LOCATION;
    }

    @Override
    protected /* synthetic */ float getWhiteOverlayProgress(LivingEntity livingEntity, float f) {
        return this.getWhiteOverlayProgress((Creeper)livingEntity, f);
    }
}

