/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import net.minecraft.CharPredicate;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;

public class ParserUtils {
    private static final Field JSON_READER_POS = Util.make(() -> {
        try {
            Field $$0 = JsonReader.class.getDeclaredField("pos");
            $$0.setAccessible(true);
            return $$0;
        }
        catch (NoSuchFieldException $$1) {
            throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", $$1);
        }
    });
    private static final Field JSON_READER_LINESTART = Util.make(() -> {
        try {
            Field $$0 = JsonReader.class.getDeclaredField("lineStart");
            $$0.setAccessible(true);
            return $$0;
        }
        catch (NoSuchFieldException $$1) {
            throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", $$1);
        }
    });

    private static int getPos(JsonReader p_313929_) {
        try {
            return JSON_READER_POS.getInt(p_313929_) - JSON_READER_LINESTART.getInt(p_313929_);
        }
        catch (IllegalAccessException $$1) {
            throw new IllegalStateException("Couldn't read position of JsonReader", $$1);
        }
    }

    public static <T> T parseJson(HolderLookup.Provider p_323581_, com.mojang.brigadier.StringReader p_313786_, Codec<T> p_313876_) {
        JsonReader $$3 = new JsonReader((Reader)new StringReader(p_313786_.getRemaining()));
        $$3.setLenient(false);
        try {
            JsonElement $$4 = Streams.parse((JsonReader)$$3);
            Object object = p_313876_.parse(p_323581_.createSerializationContext(JsonOps.INSTANCE), (Object)$$4).getOrThrow(JsonParseException::new);
            return (T)object;
        }
        catch (StackOverflowError $$5) {
            throw new JsonParseException((Throwable)$$5);
        }
        finally {
            p_313786_.setCursor(p_313786_.getCursor() + ParserUtils.getPos($$3));
        }
    }

    public static String readWhile(com.mojang.brigadier.StringReader p_332772_, CharPredicate p_332664_) {
        int $$2 = p_332772_.getCursor();
        while (p_332772_.canRead() && p_332664_.test(p_332772_.peek())) {
            p_332772_.skip();
        }
        return p_332772_.getString().substring($$2, p_332772_.getCursor());
    }
}

