/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;

public class ComponentSerialization {
    public static final Codec<Component> CODEC = Codec.recursive((String)"Component", ComponentSerialization::createCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, Component> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Component>> OPTIONAL_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs::optional);
    public static final StreamCodec<RegistryFriendlyByteBuf, Component> TRUSTED_STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistriesTrusted(CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Component>> TRUSTED_OPTIONAL_STREAM_CODEC = TRUSTED_STREAM_CODEC.apply(ByteBufCodecs::optional);
    public static final StreamCodec<ByteBuf, Component> TRUSTED_CONTEXT_FREE_STREAM_CODEC = ByteBufCodecs.fromCodecTrusted(CODEC);
    public static final Codec<Component> FLAT_CODEC = ComponentSerialization.flatCodec(Integer.MAX_VALUE);

    public static Codec<Component> flatCodec(int p_331605_) {
        final Codec $$1 = Codec.string((int)0, (int)p_331605_);
        return new Codec<Component>(){

            public <T> DataResult<Pair<Component, T>> decode(DynamicOps<T> p_330684_, T p_331653_) {
                DynamicOps<JsonElement> $$2 = 1.asJsonOps(p_330684_);
                return $$1.decode(p_330684_, p_331653_).flatMap(p_337496_ -> {
                    try {
                        JsonElement $$2 = JsonParser.parseString((String)((String)p_337496_.getFirst()));
                        return CODEC.parse($$2, (Object)$$2).map(p_330859_ -> Pair.of((Object)p_330859_, (Object)p_337496_.getSecond()));
                    }
                    catch (JsonParseException $$3) {
                        return DataResult.error($$3::getMessage);
                    }
                });
            }

            public <T> DataResult<T> encode(Component p_330452_, DynamicOps<T> p_330865_, T p_331460_) {
                DynamicOps<JsonElement> $$3 = 1.asJsonOps(p_330865_);
                return CODEC.encodeStart($$3, (Object)p_330452_).flatMap(p_331436_ -> {
                    try {
                        return $$1.encodeStart(p_330865_, (Object)GsonHelper.toStableString(p_331436_));
                    }
                    catch (IllegalArgumentException $$3) {
                        return DataResult.error($$3::getMessage);
                    }
                });
            }

            private static <T> DynamicOps<JsonElement> asJsonOps(DynamicOps<T> p_330749_) {
                if (p_330749_ instanceof RegistryOps) {
                    RegistryOps $$12 = (RegistryOps)p_330749_;
                    return $$12.withParent(JsonOps.INSTANCE);
                }
                return JsonOps.INSTANCE;
            }

            public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
                return this.encode((Component)object, dynamicOps, object2);
            }
        };
    }

    private static MutableComponent createFromList(List<Component> p_304405_) {
        MutableComponent $$1 = p_304405_.get(0).copy();
        for (int $$2 = 1; $$2 < p_304405_.size(); ++$$2) {
            $$1.append(p_304405_.get($$2));
        }
        return $$1;
    }

    public static <T extends StringRepresentable, E> MapCodec<E> createLegacyComponentMatcher(T[] p_304815_, Function<T, MapCodec<? extends E>> p_304852_, Function<E, T> p_304510_, String p_307551_) {
        FuzzyCodec<Object> $$4 = new FuzzyCodec<Object>(Stream.of(p_304815_).map(p_304852_).toList(), p_304601_ -> (MapEncoder)p_304852_.apply((StringRepresentable)p_304510_.apply(p_304601_)));
        Codec $$5 = StringRepresentable.fromValues(() -> p_304815_);
        MapCodec $$6 = $$5.dispatchMap(p_307551_, p_304510_, p_304852_);
        StrictEither<Object> $$7 = new StrictEither<Object>(p_307551_, $$6, $$4);
        return ExtraCodecs.orCompressed($$7, $$6);
    }

    private static Codec<Component> createCodec(Codec<Component> p_304554_) {
        StringRepresentable[] $$1 = new ComponentContents.Type[]{PlainTextContents.TYPE, TranslatableContents.TYPE, KeybindContents.TYPE, ScoreContents.TYPE, SelectorContents.TYPE, NbtContents.TYPE};
        MapCodec $$2 = ComponentSerialization.createLegacyComponentMatcher((StringRepresentable[])$$1, ComponentContents.Type::codec, ComponentContents::type, (String)"type");
        Codec $$3 = RecordCodecBuilder.create(p_337494_ -> p_337494_.group((App)$$2.forGetter(Component::getContents), (App)ExtraCodecs.nonEmptyList(p_304554_.listOf()).optionalFieldOf("extra", List.of()).forGetter(Component::getSiblings), (App)Style.Serializer.MAP_CODEC.forGetter(Component::getStyle)).apply((Applicative)p_337494_, MutableComponent::new));
        return Codec.either((Codec)Codec.either((Codec)Codec.STRING, ExtraCodecs.nonEmptyList(p_304554_.listOf())), (Codec)$$3).xmap(p_304547_ -> (Component)p_304547_.map(p_304568_ -> (Component)p_304568_.map(Component::literal, ComponentSerialization::createFromList), p_304887_ -> p_304887_), p_304501_ -> {
            String $$1 = p_304501_.tryCollapseToString();
            return $$1 != null ? Either.left((Object)Either.left((Object)$$1)) : Either.right((Object)p_304501_);
        });
    }

    static class FuzzyCodec<T>
    extends MapCodec<T> {
        private final List<MapCodec<? extends T>> codecs;
        private final Function<T, MapEncoder<? extends T>> encoderGetter;

        public FuzzyCodec(List<MapCodec<? extends T>> p_304495_, Function<T, MapEncoder<? extends T>> p_304594_) {
            this.codecs = p_304495_;
            this.encoderGetter = p_304594_;
        }

        public <S> DataResult<T> decode(DynamicOps<S> p_304922_, MapLike<S> p_304447_) {
            for (MapDecoder mapDecoder : this.codecs) {
                DataResult $$3 = mapDecoder.decode(p_304922_, p_304447_);
                if (!$$3.result().isPresent()) continue;
                return $$3;
            }
            return DataResult.error(() -> "No matching codec found");
        }

        public <S> RecordBuilder<S> encode(T p_304409_, DynamicOps<S> p_304945_, RecordBuilder<S> p_304823_) {
            MapEncoder<? extends T> $$3 = this.encoderGetter.apply(p_304409_);
            return $$3.encode(p_304409_, p_304945_, p_304823_);
        }

        public <S> Stream<S> keys(DynamicOps<S> p_304770_) {
            return this.codecs.stream().flatMap(p_304401_ -> p_304401_.keys(p_304770_)).distinct();
        }

        public String toString() {
            return "FuzzyCodec[" + String.valueOf(this.codecs) + "]";
        }
    }

    static class StrictEither<T>
    extends MapCodec<T> {
        private final String typeFieldName;
        private final MapCodec<T> typed;
        private final MapCodec<T> fuzzy;

        public StrictEither(String p_307439_, MapCodec<T> p_307644_, MapCodec<T> p_307415_) {
            this.typeFieldName = p_307439_;
            this.typed = p_307644_;
            this.fuzzy = p_307415_;
        }

        public <O> DataResult<T> decode(DynamicOps<O> p_307279_, MapLike<O> p_307655_) {
            if (p_307655_.get(this.typeFieldName) != null) {
                return this.typed.decode(p_307279_, p_307655_);
            }
            return this.fuzzy.decode(p_307279_, p_307655_);
        }

        public <O> RecordBuilder<O> encode(T p_307352_, DynamicOps<O> p_307510_, RecordBuilder<O> p_307297_) {
            return this.fuzzy.encode(p_307352_, p_307510_, p_307297_);
        }

        public <T1> Stream<T1> keys(DynamicOps<T1> p_307616_) {
            return Stream.concat(this.typed.keys(p_307616_), this.fuzzy.keys(p_307616_)).distinct();
        }
    }
}

