/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.OverlayMetadataSection;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.flag.FeatureFlagSet;
import org.slf4j.Logger;

public class Pack {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackLocationInfo location;
    private final ResourcesSupplier resources;
    private final Metadata metadata;
    private final PackSelectionConfig selectionConfig;

    @Nullable
    public static Pack readMetaAndCreate(PackLocationInfo p_326065_, ResourcesSupplier p_252210_, PackType p_250595_, PackSelectionConfig p_326429_) {
        int $$4 = SharedConstants.getCurrentVersion().getPackVersion(p_250595_);
        Metadata $$5 = Pack.readPackMetadata(p_326065_, p_252210_, $$4);
        return $$5 != null ? new Pack(p_326065_, p_252210_, $$5, p_326429_) : null;
    }

    public Pack(PackLocationInfo p_326123_, ResourcesSupplier p_249377_, Metadata p_326375_, PackSelectionConfig p_326282_) {
        this.location = p_326123_;
        this.resources = p_249377_;
        this.metadata = p_326375_;
        this.selectionConfig = p_326282_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Metadata readPackMetadata(PackLocationInfo p_326060_, ResourcesSupplier p_326166_, int p_326341_) {
        try (PackResources $$3 = p_326166_.openPrimary(p_326060_);){
            PackMetadataSection $$4 = $$3.getMetadataSection(PackMetadataSection.TYPE);
            if ($$4 == null) {
                LOGGER.warn("Missing metadata in pack {}", (Object)p_326060_.id());
                Metadata metadata = null;
                return metadata;
            }
            FeatureFlagsMetadataSection $$5 = $$3.getMetadataSection(FeatureFlagsMetadataSection.TYPE);
            FeatureFlagSet $$6 = $$5 != null ? $$5.flags() : FeatureFlagSet.of();
            InclusiveRange<Integer> $$7 = Pack.getDeclaredPackVersions(p_326060_.id(), $$4);
            PackCompatibility $$8 = PackCompatibility.forVersion($$7, p_326341_);
            OverlayMetadataSection $$9 = $$3.getMetadataSection(OverlayMetadataSection.TYPE);
            List<String> $$10 = $$9 != null ? $$9.overlaysForVersion(p_326341_) : List.of();
            Metadata metadata = new Metadata($$4.description(), $$8, $$6, $$10);
            return metadata;
        }
        catch (Exception $$11) {
            LOGGER.warn("Failed to read pack {} metadata", (Object)p_326060_.id(), (Object)$$11);
            return null;
        }
    }

    private static InclusiveRange<Integer> getDeclaredPackVersions(String p_295795_, PackMetadataSection p_294612_) {
        int $$2 = p_294612_.packFormat();
        if (p_294612_.supportedFormats().isEmpty()) {
            return new InclusiveRange<Integer>($$2);
        }
        InclusiveRange<Integer> $$3 = p_294612_.supportedFormats().get();
        if (!$$3.isValueInRange($$2)) {
            LOGGER.warn("Pack {} declared support for versions {} but declared main format is {}, defaulting to {}", new Object[]{p_295795_, $$3, $$2, $$2});
            return new InclusiveRange<Integer>($$2);
        }
        return $$3;
    }

    public PackLocationInfo location() {
        return this.location;
    }

    public Component getTitle() {
        return this.location.title();
    }

    public Component getDescription() {
        return this.metadata.description();
    }

    public Component getChatLink(boolean p_10438_) {
        return this.location.createChatLink(p_10438_, this.metadata.description);
    }

    public PackCompatibility getCompatibility() {
        return this.metadata.compatibility();
    }

    public FeatureFlagSet getRequestedFeatures() {
        return this.metadata.requestedFeatures();
    }

    public PackResources open() {
        return this.resources.openFull(this.location, this.metadata);
    }

    public String getId() {
        return this.location.id();
    }

    public PackSelectionConfig selectionConfig() {
        return this.selectionConfig;
    }

    public boolean isRequired() {
        return this.selectionConfig.required();
    }

    public boolean isFixedPosition() {
        return this.selectionConfig.fixedPosition();
    }

    public Position getDefaultPosition() {
        return this.selectionConfig.defaultPosition();
    }

    public PackSource getPackSource() {
        return this.location.source();
    }

    public boolean equals(Object p_10448_) {
        if (this == p_10448_) {
            return true;
        }
        if (!(p_10448_ instanceof Pack)) {
            return false;
        }
        Pack $$1 = (Pack)p_10448_;
        return this.location.equals($$1.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public static interface ResourcesSupplier {
        public PackResources openPrimary(PackLocationInfo var1);

        public PackResources openFull(PackLocationInfo var1, Metadata var2);
    }

    public record Metadata(Component description, PackCompatibility compatibility, FeatureFlagSet requestedFeatures, List<String> overlays) {
    }

    public static enum Position {
        TOP,
        BOTTOM;


        public <T> int insert(List<T> p_10471_, T p_10472_, Function<T, PackSelectionConfig> p_10473_, boolean p_10474_) {
            PackSelectionConfig $$8;
            int $$7;
            Position $$4;
            Position position = $$4 = p_10474_ ? this.opposite() : this;
            if ($$4 == BOTTOM) {
                PackSelectionConfig $$6;
                int $$5;
                for ($$5 = 0; $$5 < p_10471_.size() && ($$6 = p_10473_.apply(p_10471_.get($$5))).fixedPosition() && $$6.defaultPosition() == this; ++$$5) {
                }
                p_10471_.add($$5, p_10472_);
                return $$5;
            }
            for ($$7 = p_10471_.size() - 1; $$7 >= 0 && ($$8 = p_10473_.apply(p_10471_.get($$7))).fixedPosition() && $$8.defaultPosition() == this; --$$7) {
            }
            p_10471_.add($$7 + 1, p_10472_);
            return $$7 + 1;
        }

        public Position opposite() {
            return this == TOP ? BOTTOM : TOP;
        }
    }
}

