/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.util.DependencySorter;
import org.slf4j.Logger;

public class TagLoader<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    final Function<ResourceLocation, Optional<? extends T>> idToValue;
    private final String directory;

    public TagLoader(Function<ResourceLocation, Optional<? extends T>> p_144493_, String p_144494_) {
        this.idToValue = p_144493_;
        this.directory = p_144494_;
    }

    public Map<ResourceLocation, List<EntryWithSource>> load(ResourceManager p_144496_) {
        HashMap $$1 = Maps.newHashMap();
        FileToIdConverter $$2 = FileToIdConverter.json(this.directory);
        for (Map.Entry<ResourceLocation, List<Resource>> $$3 : $$2.listMatchingResourceStacks(p_144496_).entrySet()) {
            ResourceLocation $$4 = $$3.getKey();
            ResourceLocation $$5 = $$2.fileToId($$4);
            for (Resource $$6 : $$3.getValue()) {
                try {
                    BufferedReader $$7 = $$6.openAsReader();
                    try {
                        JsonElement $$8 = JsonParser.parseReader((Reader)$$7);
                        List $$9 = $$1.computeIfAbsent($$5, p_215974_ -> new ArrayList());
                        TagFile $$10 = (TagFile)TagFile.CODEC.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)$$8)).getOrThrow();
                        if ($$10.replace()) {
                            $$9.clear();
                        }
                        String $$11 = $$6.sourcePackId();
                        $$10.entries().forEach(p_215997_ -> $$9.add(new EntryWithSource((TagEntry)p_215997_, $$11)));
                    }
                    finally {
                        if ($$7 == null) continue;
                        ((Reader)$$7).close();
                    }
                }
                catch (Exception $$12) {
                    LOGGER.error("Couldn't read tag list {} from {} in data pack {}", new Object[]{$$5, $$4, $$6.sourcePackId(), $$12});
                }
            }
        }
        return $$1;
    }

    private Either<Collection<EntryWithSource>, Collection<T>> build(TagEntry.Lookup<T> p_215979_, List<EntryWithSource> p_215980_) {
        ImmutableSet.Builder $$2 = ImmutableSet.builder();
        ArrayList<EntryWithSource> $$3 = new ArrayList<EntryWithSource>();
        for (EntryWithSource $$4 : p_215980_) {
            if ($$4.entry().build(p_215979_, arg_0 -> ((ImmutableSet.Builder)$$2).add(arg_0))) continue;
            $$3.add($$4);
        }
        return $$3.isEmpty() ? Either.right((Object)$$2.build()) : Either.left($$3);
    }

    public Map<ResourceLocation, Collection<T>> build(Map<ResourceLocation, List<EntryWithSource>> p_203899_) {
        final HashMap $$1 = Maps.newHashMap();
        TagEntry.Lookup $$2 = new TagEntry.Lookup<T>(){

            @Override
            @Nullable
            public T element(ResourceLocation p_216039_) {
                return TagLoader.this.idToValue.apply(p_216039_).orElse(null);
            }

            @Override
            @Nullable
            public Collection<T> tag(ResourceLocation p_216041_) {
                return (Collection)$$1.get(p_216041_);
            }
        };
        DependencySorter<ResourceLocation, SortingEntry> $$3 = new DependencySorter<ResourceLocation, SortingEntry>();
        p_203899_.forEach((p_284685_, p_284686_) -> $$3.addEntry((ResourceLocation)p_284685_, new SortingEntry((List<EntryWithSource>)p_284686_)));
        $$3.orderByDependencies((p_284682_, p_284683_) -> this.build($$2, p_284683_.entries).ifLeft(p_215977_ -> LOGGER.error("Couldn't load tag {} as it is missing following references: {}", p_284682_, (Object)p_215977_.stream().map(Objects::toString).collect(Collectors.joining(", ")))).ifRight(p_216001_ -> $$1.put(p_284682_, p_216001_)));
        return $$1;
    }

    public Map<ResourceLocation, Collection<T>> loadAndBuild(ResourceManager p_203901_) {
        return this.build(this.load(p_203901_));
    }

    public record EntryWithSource(TagEntry entry, String source) {
        @Override
        public String toString() {
            return String.valueOf(this.entry) + " (from " + this.source + ")";
        }
    }

    record SortingEntry(List<EntryWithSource> entries) implements DependencySorter.Entry<ResourceLocation>
    {
        @Override
        public void visitRequiredDependencies(Consumer<ResourceLocation> p_285529_) {
            this.entries.forEach(p_285236_ -> p_285236_.entry.visitRequiredDependencies(p_285529_));
        }

        @Override
        public void visitOptionalDependencies(Consumer<ResourceLocation> p_285469_) {
            this.entries.forEach(p_284943_ -> p_284943_.entry.visitOptionalDependencies(p_285469_));
        }
    }
}

