/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.niofs.union.UnionFileSystem;
import java.lang.module.ResolvedModule;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.neoforgespi.ILaunchContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LaunchContext
implements ILaunchContext {
    private static final Logger LOG = LoggerFactory.getLogger(LaunchContext.class);
    private final IEnvironment environment;
    private final IModuleLayerManager moduleLayerManager;
    private final List<String> modLists;
    private final List<String> mods;
    private final List<String> mavenRoots;
    private final Set<Path> locatedPaths = new HashSet<Path>();

    LaunchContext(IEnvironment environment, IModuleLayerManager moduleLayerManager, List<String> modLists, List<String> mods, List<String> mavenRoots) {
        this.environment = environment;
        this.moduleLayerManager = moduleLayerManager;
        this.modLists = modLists;
        this.mods = mods;
        this.mavenRoots = mavenRoots;
        for (IModuleLayerManager.Layer layerId : IModuleLayerManager.Layer.values()) {
            moduleLayerManager.getLayer(layerId).ifPresent(layer -> {
                for (ResolvedModule resolvedModule : layer.configuration().modules()) {
                    resolvedModule.reference().location().ifPresent(moduleUri -> {
                        try {
                            this.locatedPaths.add(this.unpackPath(Paths.get(moduleUri)));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
            });
        }
        LOG.debug(LogMarkers.SCAN, "Located paths when launch context was created: {}", this.locatedPaths);
    }

    private Path unpackPath(Path path) {
        FileSystem fileSystem = path.getFileSystem();
        if (fileSystem instanceof UnionFileSystem) {
            UnionFileSystem unionFileSystem = (UnionFileSystem)fileSystem;
            return unionFileSystem.getPrimaryPath();
        }
        return path;
    }

    @Override
    public <T> Stream<ServiceLoader.Provider<T>> loadServices(Class<T> serviceClass) {
        EnumSet<IModuleLayerManager.Layer> visitedLayers = EnumSet.noneOf(IModuleLayerManager.Layer.class);
        Stream<Object> result = Stream.empty();
        IModuleLayerManager.Layer[] layers = IModuleLayerManager.Layer.values();
        for (int i = layers.length - 1; i >= 0; --i) {
            ModuleLayer layer;
            IModuleLayerManager.Layer layerId = layers[i];
            if (visitedLayers.contains(layerId) || (layer = (ModuleLayer)this.moduleLayerManager.getLayer(layerId).orElse(null)) == null) continue;
            result = Stream.concat(result, ServiceLoader.load(layer, serviceClass).stream());
            LaunchContext.visitLayer(layerId, visitedLayers::add);
        }
        return result.distinct();
    }

    private static void visitLayer(IModuleLayerManager.Layer layer, Consumer<IModuleLayerManager.Layer> consumer) {
        consumer.accept(layer);
        for (IModuleLayerManager.Layer parentLayer : layer.getParent()) {
            consumer.accept(parentLayer);
        }
    }

    @Override
    public boolean isLocated(Path path) {
        return this.locatedPaths.contains(this.unpackPath(path));
    }

    @Override
    public boolean addLocated(Path path) {
        return this.locatedPaths.add(this.unpackPath(path));
    }

    @Override
    public IEnvironment environment() {
        return this.environment;
    }

    public IModuleLayerManager moduleLayerManager() {
        return this.moduleLayerManager;
    }

    @Override
    public List<String> modLists() {
        return this.modLists;
    }

    @Override
    public List<String> mods() {
        return this.mods;
    }

    @Override
    public List<String> mavenRoots() {
        return this.mavenRoots;
    }
}

