/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ArmorStand
extends LivingEntity {
    public static final int WOBBLE_TIME = 5;
    private static final boolean ENABLE_ARMS = true;
    private static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations DEFAULT_LEFT_LEG_POSE = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations DEFAULT_RIGHT_LEG_POSE = new Rotations(1.0f, 0.0f, 1.0f);
    private static final EntityDimensions MARKER_DIMENSIONS = EntityDimensions.fixed((float)0.0f, (float)0.0f);
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.ARMOR_STAND.getDimensions().scale(0.5f).withEyeHeight(0.9875f);
    private static final double FEET_OFFSET = 0.1;
    private static final double CHEST_OFFSET = 0.9;
    private static final double LEGS_OFFSET = 0.4;
    private static final double HEAD_OFFSET = 1.6;
    public static final int DISABLE_TAKING_OFFSET = 8;
    public static final int DISABLE_PUTTING_OFFSET = 16;
    public static final int CLIENT_FLAG_SMALL = 1;
    public static final int CLIENT_FLAG_SHOW_ARMS = 4;
    public static final int CLIENT_FLAG_NO_BASEPLATE = 8;
    public static final int CLIENT_FLAG_MARKER = 16;
    public static final EntityDataAccessor<Byte> DATA_CLIENT_FLAGS = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Rotations> DATA_HEAD_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_BODY_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_ARM_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_ARM_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_LEG_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_LEG_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    private static final Predicate<Entity> RIDABLE_MINECARTS = p_31582_ -> p_31582_ instanceof AbstractMinecart && ((AbstractMinecart)((Object)((Object)p_31582_))).canBeRidden();
    private final NonNullList<ItemStack> handItems = NonNullList.withSize(2, ItemStack.EMPTY);
    private final NonNullList<ItemStack> armorItems = NonNullList.withSize(4, ItemStack.EMPTY);
    private boolean invisible;
    public long lastHit;
    private int disabledSlots;
    private Rotations headPose = DEFAULT_HEAD_POSE;
    private Rotations bodyPose = DEFAULT_BODY_POSE;
    private Rotations leftArmPose = DEFAULT_LEFT_ARM_POSE;
    private Rotations rightArmPose = DEFAULT_RIGHT_ARM_POSE;
    private Rotations leftLegPose = DEFAULT_LEFT_LEG_POSE;
    private Rotations rightLegPose = DEFAULT_RIGHT_LEG_POSE;

    public ArmorStand(EntityType<? extends ArmorStand> p_31553_, Level p_31554_) {
        super((EntityType<? extends LivingEntity>)p_31553_, p_31554_);
    }

    public ArmorStand(Level p_31556_, double p_31557_, double p_31558_, double p_31559_) {
        this((EntityType<? extends ArmorStand>)EntityType.ARMOR_STAND, p_31556_);
        this.setPos(p_31557_, p_31558_, p_31559_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ArmorStand.createLivingAttributes().add(Attributes.STEP_HEIGHT, 0.0);
    }

    @Override
    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    private boolean hasPhysics() {
        return !this.isMarker() && !this.isNoGravity();
    }

    @Override
    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && this.hasPhysics();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326283_) {
        super.defineSynchedData(p_326283_);
        p_326283_.define(DATA_CLIENT_FLAGS, (byte)0);
        p_326283_.define(DATA_HEAD_POSE, DEFAULT_HEAD_POSE);
        p_326283_.define(DATA_BODY_POSE, DEFAULT_BODY_POSE);
        p_326283_.define(DATA_LEFT_ARM_POSE, DEFAULT_LEFT_ARM_POSE);
        p_326283_.define(DATA_RIGHT_ARM_POSE, DEFAULT_RIGHT_ARM_POSE);
        p_326283_.define(DATA_LEFT_LEG_POSE, DEFAULT_LEFT_LEG_POSE);
        p_326283_.define(DATA_RIGHT_LEG_POSE, DEFAULT_RIGHT_LEG_POSE);
    }

    @Override
    public Iterable<ItemStack> getHandSlots() {
        return this.handItems;
    }

    @Override
    public Iterable<ItemStack> getArmorSlots() {
        return this.armorItems;
    }

    @Override
    public ItemStack getItemBySlot(EquipmentSlot p_31612_) {
        switch (p_31612_.getType()) {
            case HAND: {
                return this.handItems.get(p_31612_.getIndex());
            }
            case HUMANOID_ARMOR: {
                return this.armorItems.get(p_31612_.getIndex());
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean canUseSlot(EquipmentSlot p_326077_) {
        return p_326077_ != EquipmentSlot.BODY;
    }

    @Override
    public void setItemSlot(EquipmentSlot p_31584_, ItemStack p_31585_) {
        this.verifyEquippedItem(p_31585_);
        switch (p_31584_.getType()) {
            case HAND: {
                this.onEquipItem(p_31584_, this.handItems.set(p_31584_.getIndex(), p_31585_), p_31585_);
                break;
            }
            case HUMANOID_ARMOR: {
                this.onEquipItem(p_31584_, this.armorItems.set(p_31584_.getIndex(), p_31585_), p_31585_);
            }
        }
    }

    @Override
    public boolean canTakeItem(ItemStack p_31638_) {
        EquipmentSlot equipmentslot = this.getEquipmentSlotForItem(p_31638_);
        return this.getItemBySlot(equipmentslot).isEmpty() && !this.isDisabled(equipmentslot);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_31619_) {
        super.addAdditionalSaveData(p_31619_);
        ListTag listtag = new ListTag();
        for (ItemStack itemstack : this.armorItems) {
            listtag.add(itemstack.saveOptional((HolderLookup.Provider)this.registryAccess()));
        }
        p_31619_.put("ArmorItems", (Tag)listtag);
        ListTag listtag1 = new ListTag();
        for (ItemStack itemstack1 : this.handItems) {
            listtag1.add(itemstack1.saveOptional((HolderLookup.Provider)this.registryAccess()));
        }
        p_31619_.put("HandItems", (Tag)listtag1);
        p_31619_.putBoolean("Invisible", this.isInvisible());
        p_31619_.putBoolean("Small", this.isSmall());
        p_31619_.putBoolean("ShowArms", this.isShowArms());
        p_31619_.putInt("DisabledSlots", this.disabledSlots);
        p_31619_.putBoolean("NoBasePlate", this.isNoBasePlate());
        if (this.isMarker()) {
            p_31619_.putBoolean("Marker", this.isMarker());
        }
        p_31619_.put("Pose", this.writePose());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_31600_) {
        super.readAdditionalSaveData(p_31600_);
        if (p_31600_.contains("ArmorItems", 9)) {
            ListTag listtag = p_31600_.getList("ArmorItems", 10);
            for (int i = 0; i < this.armorItems.size(); ++i) {
                CompoundTag compoundtag = listtag.getCompound(i);
                this.armorItems.set(i, ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), compoundtag));
            }
        }
        if (p_31600_.contains("HandItems", 9)) {
            ListTag listtag1 = p_31600_.getList("HandItems", 10);
            for (int j = 0; j < this.handItems.size(); ++j) {
                CompoundTag compoundtag2 = listtag1.getCompound(j);
                this.handItems.set(j, ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), compoundtag2));
            }
        }
        this.setInvisible(p_31600_.getBoolean("Invisible"));
        this.setSmall(p_31600_.getBoolean("Small"));
        this.setShowArms(p_31600_.getBoolean("ShowArms"));
        this.disabledSlots = p_31600_.getInt("DisabledSlots");
        this.setNoBasePlate(p_31600_.getBoolean("NoBasePlate"));
        this.setMarker(p_31600_.getBoolean("Marker"));
        this.noPhysics = !this.hasPhysics();
        CompoundTag compoundtag1 = p_31600_.getCompound("Pose");
        this.readPose(compoundtag1);
    }

    private void readPose(CompoundTag p_31658_) {
        ListTag listtag = p_31658_.getList("Head", 5);
        this.setHeadPose(listtag.isEmpty() ? DEFAULT_HEAD_POSE : new Rotations(listtag));
        ListTag listtag1 = p_31658_.getList("Body", 5);
        this.setBodyPose(listtag1.isEmpty() ? DEFAULT_BODY_POSE : new Rotations(listtag1));
        ListTag listtag2 = p_31658_.getList("LeftArm", 5);
        this.setLeftArmPose(listtag2.isEmpty() ? DEFAULT_LEFT_ARM_POSE : new Rotations(listtag2));
        ListTag listtag3 = p_31658_.getList("RightArm", 5);
        this.setRightArmPose(listtag3.isEmpty() ? DEFAULT_RIGHT_ARM_POSE : new Rotations(listtag3));
        ListTag listtag4 = p_31658_.getList("LeftLeg", 5);
        this.setLeftLegPose(listtag4.isEmpty() ? DEFAULT_LEFT_LEG_POSE : new Rotations(listtag4));
        ListTag listtag5 = p_31658_.getList("RightLeg", 5);
        this.setRightLegPose(listtag5.isEmpty() ? DEFAULT_RIGHT_LEG_POSE : new Rotations(listtag5));
    }

    private CompoundTag writePose() {
        CompoundTag compoundtag = new CompoundTag();
        if (!DEFAULT_HEAD_POSE.equals((Object)this.headPose)) {
            compoundtag.put("Head", (Tag)this.headPose.save());
        }
        if (!DEFAULT_BODY_POSE.equals((Object)this.bodyPose)) {
            compoundtag.put("Body", (Tag)this.bodyPose.save());
        }
        if (!DEFAULT_LEFT_ARM_POSE.equals((Object)this.leftArmPose)) {
            compoundtag.put("LeftArm", (Tag)this.leftArmPose.save());
        }
        if (!DEFAULT_RIGHT_ARM_POSE.equals((Object)this.rightArmPose)) {
            compoundtag.put("RightArm", (Tag)this.rightArmPose.save());
        }
        if (!DEFAULT_LEFT_LEG_POSE.equals((Object)this.leftLegPose)) {
            compoundtag.put("LeftLeg", (Tag)this.leftLegPose.save());
        }
        if (!DEFAULT_RIGHT_LEG_POSE.equals((Object)this.rightLegPose)) {
            compoundtag.put("RightLeg", (Tag)this.rightLegPose.save());
        }
        return compoundtag;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    protected void doPush(Entity p_31564_) {
    }

    @Override
    protected void pushEntities() {
        for (Entity entity : this.level().getEntities(this, this.getBoundingBox(), RIDABLE_MINECARTS)) {
            if (!(this.distanceToSqr(entity) <= 0.2)) continue;
            entity.push(this);
        }
    }

    @Override
    public InteractionResult interactAt(Player p_31594_, Vec3 p_31595_, InteractionHand p_31596_) {
        ItemStack itemstack = p_31594_.getItemInHand(p_31596_);
        if (this.isMarker() || itemstack.is(Items.NAME_TAG)) {
            return InteractionResult.PASS;
        }
        if (p_31594_.isSpectator()) {
            return InteractionResult.SUCCESS;
        }
        if (p_31594_.level().isClientSide) {
            return InteractionResult.CONSUME;
        }
        EquipmentSlot equipmentslot = this.getEquipmentSlotForItem(itemstack);
        if (itemstack.isEmpty()) {
            EquipmentSlot equipmentslot2;
            EquipmentSlot equipmentslot1 = this.getClickedSlot(p_31595_);
            EquipmentSlot equipmentSlot = equipmentslot2 = this.isDisabled(equipmentslot1) ? equipmentslot : equipmentslot1;
            if (this.hasItemInSlot(equipmentslot2) && this.swapItem(p_31594_, equipmentslot2, itemstack, p_31596_)) {
                return InteractionResult.SUCCESS;
            }
        } else {
            if (this.isDisabled(equipmentslot)) {
                return InteractionResult.FAIL;
            }
            if (equipmentslot.getType() == EquipmentSlot.Type.HAND && !this.isShowArms()) {
                return InteractionResult.FAIL;
            }
            if (this.swapItem(p_31594_, equipmentslot, itemstack, p_31596_)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EquipmentSlot getClickedSlot(Vec3 p_31660_) {
        EquipmentSlot equipmentslot = EquipmentSlot.MAINHAND;
        boolean flag = this.isSmall();
        double d0 = p_31660_.y / (double)(this.getScale() * this.getAgeScale());
        EquipmentSlot equipmentslot1 = EquipmentSlot.FEET;
        if (d0 >= 0.1) {
            double d = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d && this.hasItemInSlot(equipmentslot1)) {
                return EquipmentSlot.FEET;
            }
        }
        double d = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d) {
            double d2 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d2 && this.hasItemInSlot(EquipmentSlot.CHEST)) {
                return EquipmentSlot.CHEST;
            }
        }
        if (d0 >= 0.4) {
            double d3 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d3 && this.hasItemInSlot(EquipmentSlot.LEGS)) {
                return EquipmentSlot.LEGS;
            }
        }
        if (d0 >= 1.6 && this.hasItemInSlot(EquipmentSlot.HEAD)) {
            return EquipmentSlot.HEAD;
        }
        if (this.hasItemInSlot(EquipmentSlot.MAINHAND)) return equipmentslot;
        if (!this.hasItemInSlot(EquipmentSlot.OFFHAND)) return equipmentslot;
        return EquipmentSlot.OFFHAND;
    }

    private boolean isDisabled(EquipmentSlot p_31627_) {
        return (this.disabledSlots & 1 << p_31627_.getFilterFlag()) != 0 || p_31627_.getType() == EquipmentSlot.Type.HAND && !this.isShowArms();
    }

    private boolean swapItem(Player p_31589_, EquipmentSlot p_31590_, ItemStack p_31591_, InteractionHand p_31592_) {
        ItemStack itemstack = this.getItemBySlot(p_31590_);
        if (!itemstack.isEmpty() && (this.disabledSlots & 1 << p_31590_.getFilterFlag() + 8) != 0) {
            return false;
        }
        if (itemstack.isEmpty() && (this.disabledSlots & 1 << p_31590_.getFilterFlag() + 16) != 0) {
            return false;
        }
        if (p_31589_.hasInfiniteMaterials() && itemstack.isEmpty() && !p_31591_.isEmpty()) {
            this.setItemSlot(p_31590_, p_31591_.copyWithCount(1));
            return true;
        }
        if (p_31591_.isEmpty() || p_31591_.getCount() <= 1) {
            this.setItemSlot(p_31590_, p_31591_);
            p_31589_.setItemInHand(p_31592_, itemstack);
            return true;
        }
        if (!itemstack.isEmpty()) {
            return false;
        }
        this.setItemSlot(p_31590_, p_31591_.split(1));
        return true;
    }

    @Override
    public boolean hurt(DamageSource p_31579_, float p_31580_) {
        if (this.isRemoved()) {
            return false;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (p_31579_.is((TagKey<DamageType>)DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                this.kill();
                return false;
            }
            if (this.isInvulnerableTo(p_31579_) || this.invisible || this.isMarker()) {
                return false;
            }
            if (p_31579_.is((TagKey<DamageType>)DamageTypeTags.IS_EXPLOSION)) {
                this.brokenByAnything(serverlevel, p_31579_);
                this.kill();
                return false;
            }
            if (p_31579_.is((TagKey<DamageType>)DamageTypeTags.IGNITES_ARMOR_STANDS)) {
                if (this.isOnFire()) {
                    this.causeDamage(serverlevel, p_31579_, 0.15f);
                } else {
                    this.igniteForSeconds(5.0f);
                }
                return false;
            }
            if (p_31579_.is((TagKey<DamageType>)DamageTypeTags.BURNS_ARMOR_STANDS) && this.getHealth() > 0.5f) {
                this.causeDamage(serverlevel, p_31579_, 4.0f);
                return false;
            }
            boolean flag1 = p_31579_.is((TagKey<DamageType>)DamageTypeTags.CAN_BREAK_ARMOR_STAND);
            boolean flag = p_31579_.is((TagKey<DamageType>)DamageTypeTags.ALWAYS_KILLS_ARMOR_STANDS);
            if (!flag1 && !flag) {
                return false;
            }
            Entity entity = p_31579_.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.getAbilities().mayBuild) {
                    return false;
                }
            }
            if (p_31579_.isCreativePlayer()) {
                this.playBrokenSound();
                this.showBreakingParticles();
                this.kill();
                return true;
            }
            long i = serverlevel.getGameTime();
            if (i - this.lastHit > 5L && !flag) {
                serverlevel.broadcastEntityEvent(this, (byte)32);
                this.gameEvent(GameEvent.ENTITY_DAMAGE, p_31579_.getEntity());
                this.lastHit = i;
            } else {
                this.brokenByPlayer(serverlevel, p_31579_);
                this.showBreakingParticles();
                this.kill();
            }
            return true;
        }
        return false;
    }

    @Override
    public void handleEntityEvent(byte p_31568_) {
        if (p_31568_ == 32) {
            if (this.level().isClientSide) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f, false);
                this.lastHit = this.level().getGameTime();
            }
        } else {
            super.handleEntityEvent(p_31568_);
        }
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_31574_) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return p_31574_ < (d0 *= 64.0) * d0;
    }

    private void showBreakingParticles() {
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles(new BlockParticleOption((ParticleType<BlockParticleOption>)ParticleTypes.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, this.getBbWidth() / 4.0f, this.getBbHeight() / 4.0f, this.getBbWidth() / 4.0f, 0.05);
        }
    }

    private void causeDamage(ServerLevel p_348633_, DamageSource p_31649_, float p_31650_) {
        float f = this.getHealth();
        if ((f -= p_31650_) <= 0.5f) {
            this.brokenByAnything(p_348633_, p_31649_);
            this.kill();
        } else {
            this.setHealth(f);
            this.gameEvent(GameEvent.ENTITY_DAMAGE, p_31649_.getEntity());
        }
    }

    private void brokenByPlayer(ServerLevel p_348677_, DamageSource p_31647_) {
        ItemStack itemstack = new ItemStack(Items.ARMOR_STAND);
        itemstack.set(DataComponents.CUSTOM_NAME, this.getCustomName());
        Block.popResource(this.level(), this.blockPosition(), itemstack);
        this.brokenByAnything(p_348677_, p_31647_);
    }

    private void brokenByAnything(ServerLevel p_348553_, DamageSource p_31654_) {
        this.playBrokenSound();
        this.dropAllDeathLoot(p_348553_, p_31654_);
        for (int i = 0; i < this.handItems.size(); ++i) {
            ItemStack itemstack = this.handItems.get(i);
            if (itemstack.isEmpty()) continue;
            Block.popResource(this.level(), this.blockPosition().above(), itemstack);
            this.handItems.set(i, ItemStack.EMPTY);
        }
        for (int j = 0; j < this.armorItems.size(); ++j) {
            ItemStack itemstack1 = this.armorItems.get(j);
            if (itemstack1.isEmpty()) continue;
            Block.popResource(this.level(), this.blockPosition().above(), itemstack1);
            this.armorItems.set(j, ItemStack.EMPTY);
        }
    }

    private void playBrokenSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    @Override
    protected float tickHeadTurn(float p_31644_, float p_31645_) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
        return 0.0f;
    }

    @Override
    public void travel(Vec3 p_31656_) {
        if (this.hasPhysics()) {
            super.travel(p_31656_);
        }
    }

    @Override
    public void setYBodyRot(float p_31670_) {
        this.yBodyRotO = this.yRotO = p_31670_;
        this.yHeadRotO = this.yHeadRot = p_31670_;
    }

    @Override
    public void setYHeadRot(float p_31668_) {
        this.yBodyRotO = this.yRotO = p_31668_;
        this.yHeadRotO = this.yHeadRot = p_31668_;
    }

    @Override
    public void tick() {
        Rotations rotations5;
        Rotations rotations4;
        Rotations rotations3;
        Rotations rotations2;
        Rotations rotations1;
        super.tick();
        Rotations rotations = this.entityData.get(DATA_HEAD_POSE);
        if (!this.headPose.equals((Object)rotations)) {
            this.setHeadPose(rotations);
        }
        if (!this.bodyPose.equals((Object)(rotations1 = this.entityData.get(DATA_BODY_POSE)))) {
            this.setBodyPose(rotations1);
        }
        if (!this.leftArmPose.equals((Object)(rotations2 = this.entityData.get(DATA_LEFT_ARM_POSE)))) {
            this.setLeftArmPose(rotations2);
        }
        if (!this.rightArmPose.equals((Object)(rotations3 = this.entityData.get(DATA_RIGHT_ARM_POSE)))) {
            this.setRightArmPose(rotations3);
        }
        if (!this.leftLegPose.equals((Object)(rotations4 = this.entityData.get(DATA_LEFT_LEG_POSE)))) {
            this.setLeftLegPose(rotations4);
        }
        if (!this.rightLegPose.equals((Object)(rotations5 = this.entityData.get(DATA_RIGHT_LEG_POSE)))) {
            this.setRightLegPose(rotations5);
        }
    }

    @Override
    protected void updateInvisibilityStatus() {
        this.setInvisible(this.invisible);
    }

    @Override
    public void setInvisible(boolean p_31663_) {
        this.invisible = p_31663_;
        super.setInvisible(p_31663_);
    }

    @Override
    public boolean isBaby() {
        return this.isSmall();
    }

    @Override
    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent(GameEvent.ENTITY_DIE);
    }

    @Override
    public boolean ignoreExplosion(Explosion p_312813_) {
        return this.isInvisible();
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return this.isMarker() ? PushReaction.IGNORE : super.getPistonPushReaction();
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return this.isMarker();
    }

    private void setSmall(boolean p_31604_) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 1, p_31604_));
    }

    public boolean isSmall() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 1) != 0;
    }

    public void setShowArms(boolean p_31676_) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 4, p_31676_));
    }

    public boolean isShowArms() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 4) != 0;
    }

    public void setNoBasePlate(boolean p_31679_) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 8, p_31679_));
    }

    public boolean isNoBasePlate() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 8) != 0;
    }

    private void setMarker(boolean p_31682_) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 16, p_31682_));
    }

    public boolean isMarker() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 0x10) != 0;
    }

    private byte setBit(byte p_31570_, int p_31571_, boolean p_31572_) {
        p_31570_ = p_31572_ ? (byte)(p_31570_ | p_31571_) : (byte)(p_31570_ & ~p_31571_);
        return p_31570_;
    }

    public void setHeadPose(Rotations p_31598_) {
        this.headPose = p_31598_;
        this.entityData.set(DATA_HEAD_POSE, p_31598_);
    }

    public void setBodyPose(Rotations p_31617_) {
        this.bodyPose = p_31617_;
        this.entityData.set(DATA_BODY_POSE, p_31617_);
    }

    public void setLeftArmPose(Rotations p_31624_) {
        this.leftArmPose = p_31624_;
        this.entityData.set(DATA_LEFT_ARM_POSE, p_31624_);
    }

    public void setRightArmPose(Rotations p_31629_) {
        this.rightArmPose = p_31629_;
        this.entityData.set(DATA_RIGHT_ARM_POSE, p_31629_);
    }

    public void setLeftLegPose(Rotations p_31640_) {
        this.leftLegPose = p_31640_;
        this.entityData.set(DATA_LEFT_LEG_POSE, p_31640_);
    }

    public void setRightLegPose(Rotations p_31652_) {
        this.rightLegPose = p_31652_;
        this.entityData.set(DATA_RIGHT_LEG_POSE, p_31652_);
    }

    public Rotations getHeadPose() {
        return this.headPose;
    }

    public Rotations getBodyPose() {
        return this.bodyPose;
    }

    public Rotations getLeftArmPose() {
        return this.leftArmPose;
    }

    public Rotations getRightArmPose() {
        return this.rightArmPose;
    }

    public Rotations getLeftLegPose() {
        return this.leftLegPose;
    }

    public Rotations getRightLegPose() {
        return this.rightLegPose;
    }

    @Override
    public boolean isPickable() {
        return super.isPickable() && !this.isMarker();
    }

    @Override
    public boolean skipAttackInteraction(Entity p_31687_) {
        return p_31687_ instanceof Player && !this.level().mayInteract((Player)p_31687_, this.blockPosition());
    }

    @Override
    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    @Override
    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.ARMOR_STAND_FALL, SoundEvents.ARMOR_STAND_FALL);
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_31636_) {
        return SoundEvents.ARMOR_STAND_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ARMOR_STAND_BREAK;
    }

    @Override
    public void thunderHit(ServerLevel p_31576_, LightningBolt p_31577_) {
    }

    @Override
    public boolean isAffectedByPotions() {
        return false;
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_31602_) {
        if (DATA_CLIENT_FLAGS.equals(p_31602_)) {
            this.refreshDimensions();
            this.blocksBuilding = !this.isMarker();
        }
        super.onSyncedDataUpdated(p_31602_);
    }

    @Override
    public boolean attackable() {
        return false;
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose p_31587_) {
        return this.getDimensionsMarker(this.isMarker());
    }

    private EntityDimensions getDimensionsMarker(boolean p_31684_) {
        if (p_31684_) {
            return MARKER_DIMENSIONS;
        }
        return this.isBaby() ? BABY_DIMENSIONS : this.getType().getDimensions();
    }

    @Override
    public Vec3 getLightProbePosition(float p_31665_) {
        if (this.isMarker()) {
            AABB aabb = this.getDimensionsMarker(false).makeBoundingBox(this.position());
            BlockPos blockpos = this.blockPosition();
            int i = Integer.MIN_VALUE;
            for (BlockPos blockpos1 : BlockPos.betweenClosed((BlockPos)BlockPos.containing((double)aabb.minX, (double)aabb.minY, (double)aabb.minZ), (BlockPos)BlockPos.containing((double)aabb.maxX, (double)aabb.maxY, (double)aabb.maxZ))) {
                int j = Math.max(this.level().getBrightness(LightLayer.BLOCK, blockpos1), this.level().getBrightness(LightLayer.SKY, blockpos1));
                if (j == 15) {
                    return Vec3.atCenterOf((Vec3i)blockpos1);
                }
                if (j <= i) continue;
                i = j;
                blockpos = blockpos1.immutable();
            }
            return Vec3.atCenterOf((Vec3i)blockpos);
        }
        return super.getLightProbePosition(p_31665_);
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.ARMOR_STAND);
    }

    @Override
    public boolean canBeSeenByAnyone() {
        return !this.isInvisible() && !this.isMarker();
    }
}

