/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.util.flag;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.flag.FeatureFlagRegistry;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class FeatureFlagLoader {
    private static final Gson GSON = new Gson();

    private FeatureFlagLoader() {
    }

    public static void loadModdedFlags(FeatureFlagRegistry.Builder builder) {
        HashMap<IModInfo, Path> pathPerMod = new HashMap<IModInfo, Path>();
        LoadingModList.get().getModFiles().stream().map(ModFileInfo::getMods).flatMap(Collection::stream).forEach(mod -> mod.getConfig().getConfigElement(new String[]{"featureFlags"}).ifPresent(file -> {
            Path path = mod.getOwningFile().getFile().findResource(new String[]{file});
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                ModLoader.addLoadingIssue((ModLoadingIssue)ModLoadingIssue.error((String)"fml.modloadingissue.feature_flags.file_not_found", (Object[])new Object[]{path}).withAffectedMod(mod));
                return;
            }
            pathPerMod.put((IModInfo)mod, path);
        }));
        pathPerMod.forEach((mod, path) -> {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                JsonObject obj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                JsonArray flagArray = GsonHelper.getAsJsonArray((JsonObject)obj, (String)"flags");
                for (JsonElement elem : flagArray) {
                    String flagName = GsonHelper.convertToString((JsonElement)elem, (String)"flag");
                    ResourceLocation flagLocation = ResourceLocation.parse((String)flagName);
                    Preconditions.checkArgument((boolean)flagLocation.getNamespace().equals(mod.getModId()), (String)"Cannot add new flags to foreign namespaces: %s", (Object)flagLocation);
                    builder.create(flagLocation, true);
                }
            }
            catch (Throwable e) {
                ModLoader.addLoadingIssue((ModLoadingIssue)ModLoadingIssue.error((String)"fml.modloadingissue.feature_flags.loading_error", (Object[])new Object[]{path}).withAffectedMod(mod).withCause(e));
            }
        });
    }
}

