/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui.analysis.config;

import dev.kostromdan.mods.crash_assistant.app.gui.analysis.config.ConfigChecker;
import dev.kostromdan.mods.crash_assistant.nightconfig.json.JsonParser;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public final class NightConfigJsonChecker
implements ConfigChecker {
    private static final Set<String> EXTENSIONS = new LinkedHashSet<String>(Arrays.asList("json", "json5"));

    @Override
    public Set<String> supportedExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return "NightConfig JSON parser";
    }

    @Override
    public void check(Path path) throws Exception {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            new JsonParser().parse((Reader)reader);
        }
    }
}

