/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class HsErrHelper {
    public static void removeHsErrLog(long pid) {
        if (pid == -1L) {
            return;
        }
        HsErrHelper.locateHsErrLog(pid).ifPresent(logPath -> {
            try {
                Files.deleteIfExists(logPath);
            }
            catch (IOException e) {
                CrashAssistantApp.LOGGER.error("Error while deleting hs_err log file", (Throwable)e);
            }
        });
    }

    public static Optional<Path> locateHsErrLog(long pid) {
        String fileName;
        Path rootFolder = Paths.get(".", new String[0]);
        Path logPath = rootFolder.resolve(fileName = "hs_err_pid" + pid + ".log");
        if (Files.exists(logPath, new LinkOption[0])) {
            return Optional.of(logPath);
        }
        return Optional.empty();
    }
}

