/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils.mods_downloader;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.utils.mods_downloader.api.CurseForge;
import dev.kostromdan.mods.crash_assistant.app.utils.mods_downloader.api.Modrinth;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class ModPlatformLookupService {
    public LookupResult lookup(Set<Long> curseForgeFingerprints, Set<String> modrinthFingerprints) {
        boolean needMr;
        HashMap<Long, CurseForge.FingerprintMatch> cf = new HashMap<Long, CurseForge.FingerprintMatch>();
        HashMap<String, Modrinth.VersionFileInfo> mr = new HashMap<String, Modrinth.VersionFileInfo>();
        boolean needCf = curseForgeFingerprints != null && !curseForgeFingerprints.isEmpty();
        boolean bl = needMr = modrinthFingerprints != null && !modrinthFingerprints.isEmpty();
        if (needCf && needMr) {
            CompletableFuture<Void> cfFuture = CompletableFuture.runAsync(() -> cf.putAll(this.runWithRetry(() -> CurseForge.lookupFingerprints(curseForgeFingerprints))));
            CompletableFuture<Void> mrFuture = CompletableFuture.runAsync(() -> mr.putAll(this.runWithRetry(() -> Modrinth.lookupVersionFiles(modrinthFingerprints))));
            CompletableFuture.allOf(cfFuture, mrFuture).join();
        } else {
            if (needCf) {
                cf.putAll(this.runWithRetry(() -> CurseForge.lookupFingerprints(curseForgeFingerprints)));
            }
            if (needMr) {
                mr.putAll(this.runWithRetry(() -> Modrinth.lookupVersionFiles(modrinthFingerprints)));
            }
        }
        return new LookupResult(cf, mr);
    }

    /*
     * Loose catch block
     */
    private <T> T runWithRetry(Callable<T> task) {
        int attempts = 0;
        while (true) {
            try {
                return task.call();
            }
            catch (IOException ioe) {
                CrashAssistantApp.LOGGER.warn("Lookup attempt {} failed due to connection issue, retrying...", (Object)(++attempts), (Object)ioe);
                try {
                    TimeUnit.SECONDS.sleep(Math.min(5, 1 + attempts));
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Lookup interrupted while retrying", ie);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Lookup failed", e);
        }
    }

    public static class LookupResult {
        private final Map<Long, CurseForge.FingerprintMatch> curseForgeMatches;
        private final Map<String, Modrinth.VersionFileInfo> modrinthMatches;

        public LookupResult(Map<Long, CurseForge.FingerprintMatch> curseForgeMatches, Map<String, Modrinth.VersionFileInfo> modrinthMatches) {
            this.curseForgeMatches = curseForgeMatches == null ? Collections.emptyMap() : curseForgeMatches;
            this.modrinthMatches = modrinthMatches == null ? Collections.emptyMap() : modrinthMatches;
        }

        public Map<Long, CurseForge.FingerprintMatch> getCurseForgeMatches() {
            return this.curseForgeMatches;
        }

        public Map<String, Modrinth.VersionFileInfo> getModrinthMatches() {
            return this.modrinthMatches;
        }
    }
}

