/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils.mods_downloader.api;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CurseForge {
    private static final String API_KEY = "$2a$10$mUzm1tGasW4kVV7Yw1zjBO9AmFcJClNyjLUsgIZv5E.h/zEcrAlpG";
    private static final String BASE_URL = "https://api.curseforge.com/v1";
    private static final Gson GSON = new Gson();
    private static final ConcurrentHashMap<Long, SlugInfo> SLUG_CACHE = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, FingerprintMatch> lookupFingerprints(Collection<Long> fingerprints) throws IOException {
        HashMap<Long, FingerprintMatch> result = new HashMap<Long, FingerprintMatch>();
        if (fingerprints == null || fingerprints.isEmpty()) {
            return result;
        }
        LinkedHashSet<Long> deduped = new LinkedHashSet<Long>();
        for (Long fp : fingerprints) {
            if (fp == null || fp <= 0L) continue;
            deduped.add(fp);
        }
        if (deduped.isEmpty()) {
            return result;
        }
        HttpURLConnection connection = null;
        try {
            Object line;
            URL url = new URL("https://api.curseforge.com/v1/fingerprints");
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("x-api-key", API_KEY);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(8000);
            connection.setReadTimeout(20000);
            connection.setDoOutput(true);
            JsonObject payload = new JsonObject();
            JsonArray arr = new JsonArray();
            for (Long fp : deduped) {
                arr.add((Number)fp);
            }
            payload.add("fingerprints", (JsonElement)arr);
            byte[] body = payload.toString().getBytes(StandardCharsets.UTF_8);
            try (OutputStream os = connection.getOutputStream();){
                os.write(body);
            }
            int code = connection.getResponseCode();
            if (code != 200) {
                CrashAssistantApp.LOGGER.warn("CurseForge fingerprint lookup failed with HTTP {}", (Object)code);
                HashMap<Long, FingerprintMatch> hashMap = result;
                return hashMap;
            }
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                while ((line = reader.readLine()) != null) {
                    sb.append((String)line);
                }
            }
            JsonObject response = (JsonObject)GSON.fromJson(sb.toString(), JsonObject.class);
            if (response == null || !response.has("data")) {
                line = result;
                return line;
            }
            JsonObject data = response.getAsJsonObject("data");
            if (!data.has("exactMatches") || !data.get("exactMatches").isJsonArray()) {
                HashMap<Long, FingerprintMatch> hashMap = result;
                return hashMap;
            }
            JsonArray exactMatches = data.getAsJsonArray("exactMatches");
            for (JsonElement matchEl : exactMatches) {
                JsonObject matchObj = matchEl.getAsJsonObject();
                JsonObject fileObj = matchObj.getAsJsonObject("file");
                if (fileObj == null) continue;
                long fp = fileObj.has("fileFingerprint") ? fileObj.get("fileFingerprint").getAsLong() : -1L;
                long modId = fileObj.has("modId") ? fileObj.get("modId").getAsLong() : -1L;
                long fileId = fileObj.has("id") ? fileObj.get("id").getAsLong() : -1L;
                String downloadUrl = CurseForge.getAsString(fileObj, "downloadUrl");
                String fileName = CurseForge.getAsString(fileObj, "fileName");
                if (fp <= 0L) continue;
                result.put(fp, new FingerprintMatch(fp, modId, fileId, fileName, downloadUrl));
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to query CurseForge fingerprints API", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SlugInfo resolveSlug(long modId) {
        if (modId <= 0L) {
            return null;
        }
        SlugInfo cached = SLUG_CACHE.get(modId);
        if (cached != null) {
            return cached;
        }
        HttpURLConnection connection = null;
        try {
            int idx;
            String line;
            URL url = new URL("https://api.curseforge.com/v1/mods/" + modId);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("x-api-key", API_KEY);
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(8000);
            connection.setReadTimeout(15000);
            int code = connection.getResponseCode();
            if (code != 200) {
                CrashAssistantApp.LOGGER.warn("CurseForge slug lookup failed for mod {} with HTTP {}", (Object)modId, (Object)code);
                SlugInfo slugInfo = null;
                return slugInfo;
            }
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            JsonObject response = (JsonObject)GSON.fromJson(sb.toString(), JsonObject.class);
            if (response == null || !response.has("data")) {
                line = null;
                return line;
            }
            JsonObject data = response.getAsJsonObject("data");
            String slug = CurseForge.getAsString(data, "slug");
            String websiteUrl = null;
            if (data.has("links") && data.get("links").isJsonObject()) {
                websiteUrl = CurseForge.getAsString(data.getAsJsonObject("links"), "websiteUrl");
            }
            if (slug == null && websiteUrl != null && (idx = websiteUrl.lastIndexOf(47)) >= 0 && idx < websiteUrl.length() - 1) {
                slug = websiteUrl.substring(idx + 1);
            }
            SlugInfo info = new SlugInfo(slug, websiteUrl);
            SLUG_CACHE.put(modId, info);
            SlugInfo slugInfo = info;
            return slugInfo;
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to resolve CurseForge slug for mod " + modId, (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    private static String getAsString(JsonObject obj, String key) {
        if (obj == null || key == null || !obj.has(key) || obj.get(key).isJsonNull()) {
            return null;
        }
        try {
            return obj.get(key).getAsString();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static class FingerprintMatch {
        public final long fingerprint;
        public final long modId;
        public final long fileId;
        public final String fileName;
        public final String downloadUrl;

        public FingerprintMatch(long fingerprint, long modId, long fileId, String fileName, String downloadUrl) {
            this.fingerprint = fingerprint;
            this.modId = modId;
            this.fileId = fileId;
            this.fileName = fileName;
            this.downloadUrl = downloadUrl;
        }

        public boolean hasDownload() {
            return this.downloadUrl != null && !this.downloadUrl.trim().isEmpty();
        }
    }

    public static class SlugInfo {
        public final String slug;
        public final String websiteUrl;

        public SlugInfo(String slug, String websiteUrl) {
            this.slug = slug;
            this.websiteUrl = websiteUrl;
        }
    }
}

