/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.common.me.ticker;

import appeng.api.networking.IGridNode;
import appeng.parts.AEBasePart;
import com.glodblock.github.ae2netanalyser.common.me.ticker.ProfileData;
import com.glodblock.github.ae2netanalyser.common.me.ticker.ProfilerJob;
import com.glodblock.github.ae2netanalyser.network.AEANetworkHandler;
import com.glodblock.github.ae2netanalyser.network.packets.SProfileDataUpdate;
import com.glodblock.github.glodium.Glodium;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class RequestBox {
    private static final Map<Player, ProfilerJob> WAITING = new ConcurrentHashMap<Player, ProfilerJob>();

    public static void init() {
        NeoForge.EVENT_BUS.register(RequestBox.class);
    }

    @SubscribeEvent
    public static void clear(ServerStartingEvent event) {
        WAITING.clear();
    }

    @SubscribeEvent
    public static void check(LevelTickEvent.Pre event) {
        if (!event.getLevel().isClientSide() && RequestBox.hasJob()) {
            ArrayList<Player> toRemove = new ArrayList<Player>();
            for (Map.Entry<Player, ProfilerJob> entry : WAITING.entrySet()) {
                if (!entry.getValue().isFinished()) continue;
                toRemove.add(entry.getKey());
                RequestBox.sendData(entry.getKey(), entry.getValue().generateData());
            }
            for (Player player : toRemove) {
                WAITING.remove(player);
            }
        }
    }

    @SubscribeEvent
    public static void playerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        WAITING.remove(event.getEntity());
    }

    public static boolean checkPermission(Player player) {
        MinecraftServer server = Glodium.INSTANCE.getServer();
        if (server != null) {
            if (server.isSingleplayer()) {
                return true;
            }
            return server.getPlayerList().isOp(player.getGameProfile());
        }
        return false;
    }

    public static RespondCode requestProfile(Player player, int duration) {
        if (WAITING.containsKey(player)) {
            return RespondCode.WAIT;
        }
        if (!RequestBox.checkPermission(player)) {
            return RespondCode.DENY;
        }
        WAITING.put(player, new ProfilerJob((long)duration * 1000L * 1000L * 1000L));
        return RespondCode.OK;
    }

    public static boolean cancelProfile(Player player) {
        if (WAITING.containsKey(player)) {
            WAITING.remove(player);
            return true;
        }
        return false;
    }

    public static boolean hasJob() {
        return !WAITING.isEmpty();
    }

    public static void acceptTick(long ns, long tick, IGridNode node) {
        if (WAITING.isEmpty()) {
            return;
        }
        ServerLevel world = node.getLevel();
        Object host = node.getOwner();
        if (world != null && !world.isClientSide() && host != null && ns > 0L && tick > 0L) {
            AEBasePart part;
            BlockPos pos = null;
            if (host instanceof BlockEntity) {
                BlockEntity te = (BlockEntity)host;
                pos = te.getBlockPos();
            } else if (host instanceof AEBasePart && (part = (AEBasePart)host).getHost() != null) {
                pos = part.getBlockEntity().getBlockPos();
            }
            if (pos != null) {
                GlobalPos gp = GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos);
                for (Map.Entry<Player, ProfilerJob> e : WAITING.entrySet()) {
                    e.getValue().tick(gp, ns, tick);
                }
            }
        }
    }

    private static void sendData(Player player, ProfileData data) {
        if (player instanceof ServerPlayer) {
            ServerPlayer server = (ServerPlayer)player;
            AEANetworkHandler.INSTANCE.sendTo(new SProfileDataUpdate(data), server);
            player.displayClientMessage((Component)Component.translatable((String)"chat.ae2netanalyser.tick_analyser.finish"), false);
        }
    }

    public static enum RespondCode {
        OK,
        WAIT,
        DENY;

    }
}

