/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.placer;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.GeneralScreenHandler;
import com.yogpc.qp.machine.QpEntityBlock;
import com.yogpc.qp.machine.placer.AbstractPlacerTile;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractPlacerBlock
extends QpEntityBlock {
    public AbstractPlacerBlock(String name) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).pushReaction(PushReaction.BLOCK).strength(1.2f), name, b -> new BlockItem((Block)b, new Item.Properties()));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.isCrouching() && stack.is(Items.REDSTONE_TORCH)) {
            BlockEntity blockEntity;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof AbstractPlacerTile) {
                AbstractPlacerTile placer = (AbstractPlacerTile)blockEntity;
                if (placer.enabled) {
                    placer.cycleRedStoneMode();
                    player.displayClientMessage((Component)Component.translatable((String)"quarryplus.chat.placer_rs", (Object[])new Object[]{placer.redstoneMode.toString()}), false);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.getName()}), true);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractPlacerTile) {
            AbstractPlacerTile placer = (AbstractPlacerTile)blockEntity;
            if (!level.isClientSide()) {
                if (placer.enabled) {
                    PlatformAccess.getAccess().openGui((ServerPlayer)player, this.createScreenHandler(placer));
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.getName()}), true);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected abstract GeneralScreenHandler<?> createScreenHandler(AbstractPlacerTile var1);

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractPlacerTile) {
            AbstractPlacerTile placer = (AbstractPlacerTile)blockEntity;
            boolean isPowered = (Boolean)state.getValue((Property)BlockStateProperties.TRIGGERED);
            if (isPowered) {
                placer.placeBlock();
            } else {
                placer.breakBlock();
            }
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        boolean poweredOld;
        AbstractPlacerTile placer;
        boolean poweredNow;
        BlockEntity blockEntity;
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof AbstractPlacerTile && (poweredNow = (placer = (AbstractPlacerTile)blockEntity).isPowered()) != (poweredOld = ((Boolean)state.getValue((Property)BlockStateProperties.TRIGGERED)).booleanValue())) {
            level.scheduleTick(pos, (Block)this, 1);
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(poweredNow)), 4);
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"quarryplus.tooltip.placer_plus"));
        }
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }
}

