/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.storage;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.storage.DebugStorageEntity;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public final class DebugStorageContainer
extends AbstractContainerMenu {
    public static final String NAME = "gui_debug_storage";
    final DebugStorageEntity storage;

    public DebugStorageContainer(int syncId, Inventory inventory, BlockPos pos) {
        super(PlatformAccess.getAccess().registerObjects().debugStorageContainer().get(), syncId);
        this.storage = Objects.requireNonNull((DebugStorageEntity)inventory.player.level().getBlockEntity(pos));
        int inventoryX = 29;
        int inventoryY = 107;
        int oneBox = 18;
        for (int h = 0; h < 3; ++h) {
            for (int v = 0; v < 9; ++v) {
                this.addSlot(new Slot((Container)inventory, v + h * 9 + 9, inventoryX + v * oneBox, inventoryY + h * oneBox));
            }
        }
        for (int vertical = 0; vertical < 9; ++vertical) {
            this.addSlot(new Slot((Container)inventory, vertical, inventoryX + vertical * oneBox, inventoryY + 58));
        }
        this.storage.startOpen(inventory.player);
        this.storage.syncToClient();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.storage.getBlockPos().closerToCenterThan((Position)player.position(), 8.0);
    }

    public void removed(Player player) {
        super.removed(player);
        this.storage.stopOpen(player);
    }
}

