/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.api.stacks.GenericStack;
import appeng.api.storage.ISubMenuHost;
import appeng.menu.MenuOpener;
import appeng.menu.guisync.GuiSync;
import appeng.menu.locator.MenuHostLocator;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.common.definitions.AAEComponents;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.gui.QuantumArmorFilterConfigMenu;

public class QuantumArmorMagnetMenu
extends QuantumArmorFilterConfigMenu {
    @GuiSync(value=8)
    public boolean blacklist;
    @GuiSync(value=9)
    public int currentValue = -1;
    private static final String SET_BLACKLIST = "set_blacklist";
    private static final String SET_CURRENT_VALUE = "set_current_value";

    public QuantumArmorMagnetMenu(int id, Inventory playerInventory, ISubMenuHost host) {
        super(AAEMenus.QUANTUM_ARMOR_MAGNET.get(), id, playerInventory, host);
        this.registerClientAction(SET_BLACKLIST, Boolean.class, this::setBlacklist);
        this.registerClientAction(SET_CURRENT_VALUE, Integer.class, this::setCurrentValue);
    }

    public static void open(ServerPlayer player, MenuHostLocator locator, int slotIndex, List<GenericStack> filterList, int currentValue, boolean blacklist) {
        MenuOpener.open(AAEMenus.QUANTUM_ARMOR_MAGNET.get(), (Player)player, (MenuHostLocator)locator);
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof QuantumArmorMagnetMenu) {
            QuantumArmorMagnetMenu cca = (QuantumArmorMagnetMenu)abstractContainerMenu;
            cca.setUpgradeType(UpgradeType.MAGNET);
            cca.setSlotIndex(slotIndex);
            cca.setFilterList(filterList);
            cca.setBlacklist(blacklist);
            cca.setCurrentValue(currentValue);
            cca.broadcastChanges();
        }
    }

    public void setBlacklist(boolean blacklist) {
        QuantumArmorBase item;
        if (this.isClientSide()) {
            this.sendClientAction(SET_BLACKLIST, blacklist);
            return;
        }
        this.blacklist = blacklist;
        ItemStack stack = this.getPlayer().getInventory().getItem(this.slotIndex);
        Item item2 = stack.getItem();
        if (item2 instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).getPossibleUpgrades().contains((Object)this.upgradeType) && item.hasUpgrade(stack, this.upgradeType)) {
            stack.set(AAEComponents.UPGRADE_EXTRA.get((Object)this.upgradeType), (Object)blacklist);
        }
    }

    public void setCurrentValue(int value) {
        Integer currentValue;
        QuantumArmorBase item;
        if (this.isClientSide()) {
            this.sendClientAction(SET_CURRENT_VALUE, value);
            return;
        }
        this.currentValue = value;
        ItemStack stack = this.getPlayer().getInventory().getItem(this.slotIndex);
        Item item2 = stack.getItem();
        if (item2 instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).getPossibleUpgrades().contains((Object)this.upgradeType) && stack.has(AAEComponents.UPGRADE_VALUE.get((Object)this.upgradeType)) && ((currentValue = (Integer)stack.get(AAEComponents.UPGRADE_VALUE.get((Object)this.upgradeType))) == null || currentValue != value)) {
            stack.set(AAEComponents.UPGRADE_VALUE.get((Object)this.upgradeType), (Object)value);
        }
    }

    @Override
    public void returnFromSetAmountMenu() {
        List<GenericStack> filterList = this.makeFilterList();
        Player player = this.getPlayerInventory().player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            QuantumArmorMagnetMenu.open(serverPlayer, this.getLocator(), this.slotIndex, filterList, this.currentValue, this.blacklist);
        }
    }
}

