/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.owner;

import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BasePeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PeripheralOwnerAbility;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TileEntityFuelAbility;
import de.srendi.advancedperipherals.common.blocks.base.BaseBlock;
import de.srendi.advancedperipherals.common.blocks.blockentities.InventoryManagerEntity;
import de.srendi.advancedperipherals.common.util.DataStorageUtil;
import de.srendi.advancedperipherals.common.util.fakeplayer.APFakePlayer;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralTileEntity;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityPeripheralOwner<T extends BlockEntity>
extends BasePeripheralOwner {
    public final T tileEntity;

    public BlockEntityPeripheralOwner(T tileEntity) {
        this.tileEntity = tileEntity;
    }

    @Override
    @Nullable
    public String getCustomName() {
        Nameable nameableEntity;
        Component name;
        T t = this.tileEntity;
        if (t instanceof Nameable && (name = (nameableEntity = (Nameable)t).getCustomName()) != null) {
            return name.getString();
        }
        return null;
    }

    @Override
    @NotNull
    public Level getLevel() {
        return Objects.requireNonNull(this.tileEntity.getLevel());
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return this.tileEntity.getBlockPos();
    }

    @Override
    @NotNull
    public Direction getFacing() {
        return ((FrontAndTop)this.tileEntity.getBlockState().getValue((Property)JigsawBlock.ORIENTATION)).front();
    }

    @Override
    @NotNull
    public FrontAndTop getOrientation() {
        return (FrontAndTop)this.tileEntity.getBlockState().getValue(BaseBlock.ORIENTATION);
    }

    @Override
    @Nullable
    public Player getOwner() {
        T t = this.tileEntity;
        if (t instanceof InventoryManagerEntity) {
            InventoryManagerEntity inventoryManagerEntity = (InventoryManagerEntity)t;
            return inventoryManagerEntity.getOwnerPlayer();
        }
        return null;
    }

    @Override
    public DataComponentPatch getDataStorage() {
        AdvancedPeripherals.debug("Block Entity peripheral at " + String.valueOf(this.getPos()) + " tried to use data component storage but it should instead use nbt storage, report to github!", org.apache.logging.log4j.Level.WARN);
        return DataComponentPatch.EMPTY;
    }

    @Override
    public CompoundTag getNbtStorage() {
        return DataStorageUtil.getDataStorage((IPeripheralTileEntity)this.tileEntity);
    }

    @Override
    public void putDataStorage(DataComponentPatch dataStorage) {
        AdvancedPeripherals.debug("Block Entity peripheral at " + String.valueOf(this.getPos()) + " tried to use data component storage but it should instead use nbt storage, report to github!", org.apache.logging.log4j.Level.WARN);
    }

    @Override
    public void markDataStorageDirty() {
        this.tileEntity.setChanged();
    }

    public <T1> T1 withPlayer(Function<APFakePlayer, T1> function) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public ItemStack getToolInMainHand() {
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack storeItem(ItemStack stored) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public void destroyUpgrade() {
        this.getLevel().removeBlock(this.tileEntity.getBlockPos(), false);
    }

    @Override
    public boolean isMovementPossible(@NotNull Level level, @NotNull BlockPos pos) {
        return false;
    }

    @Override
    public boolean move(@NotNull Level level, @NotNull BlockPos pos) {
        return false;
    }

    public BlockEntityPeripheralOwner<T> attachFuel() {
        this.attachAbility(PeripheralOwnerAbility.FUEL, new TileEntityFuelAbility(this));
        return this;
    }
}

