/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.FuelAbility;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PeripheralOwnerAbility;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins.AutomataCorePlugin;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.lib.peripherals.AutomataCorePeripheral;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class AutomataChargingPlugin
extends AutomataCorePlugin {
    public AutomataChargingPlugin(AutomataCorePeripheral automataCore) {
        super(automataCore);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult chargeTurtle(@NotNull IArguments arguments) throws LuaException {
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        FuelAbility<?> fuelAbility = owner.getAbility(PeripheralOwnerAbility.FUEL);
        Objects.requireNonNull(fuelAbility);
        if (fuelAbility.isFuelConsumptionDisable()) {
            return MethodResult.of((Object[])new Object[]{null, "Fuel consumption is disabled, why do you even need this?"});
        }
        ItemStack stack = owner.getToolInMainHand();
        int fuel = arguments.optInt(0, -1);
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage != null) {
            int availableFuelSpace = fuelAbility.getFuelMaxCount() - fuelAbility.getFuelCount();
            int requestedRF = fuel != -1 ? fuel * (Integer)APConfig.METAPHYSICS_CONFIG.energyToFuelRate.get() : energyStorage.getEnergyStored();
            int realConsumedRF = energyStorage.extractEnergy(Math.min(requestedRF, availableFuelSpace * (Integer)APConfig.METAPHYSICS_CONFIG.energyToFuelRate.get()), false);
            int receivedFuel = realConsumedRF / (Integer)APConfig.METAPHYSICS_CONFIG.energyToFuelRate.get();
            fuelAbility.addFuel(receivedFuel);
            this.automataCore.addRotationCycle();
            return MethodResult.of((Object[])new Object[]{true, receivedFuel});
        }
        return MethodResult.of((Object)false);
    }
}

