/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.refinedstorage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSApi;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemItemHandler;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import de.srendi.advancedperipherals.common.util.inventory.StorageProcessor;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RSItemHandler
implements IStorageSystemItemHandler {
    @NotNull
    private final Network network;
    private final StorageNetworkComponent component;

    public RSItemHandler(@NotNull Network network) {
        this.network = network;
        this.component = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
    }

    @Override
    @NotNull
    public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate) {
        long insertedAmount = this.component.insert((ResourceKey)ItemResource.ofItemStack((ItemStack)stack), (long)stack.getCount(), simulate ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
        ItemStack remain = stack.copyWithCount((int)((long)stack.getCount() - insertedAmount));
        return remain;
    }

    @Override
    public int extractItems(ItemFilter filter, StorageProcessor<ItemStack> processor, boolean simulate) {
        List<ItemResource> items = RSApi.getItems(this.network, filter);
        if (items.isEmpty()) {
            return 0;
        }
        int needs = filter.getCount();
        for (ItemResource itemResource : items) {
            int extracted;
            int amount = (int)this.component.extract((ResourceKey)itemResource, (long)needs, Action.SIMULATE, Actor.EMPTY);
            if (amount == 0 || (extracted = processor.process(itemResource.toItemStack((long)amount))) == 0) continue;
            needs -= extracted;
            if (!simulate) {
                this.component.extract((ResourceKey)itemResource, (long)extracted, Action.EXECUTE, Actor.EMPTY);
            }
            if (needs > 0) continue;
            break;
        }
        return filter.getCount() - needs;
    }
}

