/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.util.CoordUtil;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemItemHandler;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtil {
    private InventoryUtil() {
    }

    public static IItemHandler extractHandler(@Nullable Object object, @Nullable Level level, @Nullable BlockPos pos, @Nullable Direction direction) {
        if (object instanceof IItemHandler) {
            IItemHandler itemHandler = (IItemHandler)object;
            return itemHandler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        if (object instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)object;
            if (level == null && pos == null) {
                pos = blockEntity.getBlockPos();
                level = blockEntity.getLevel();
            }
        }
        if (level != null && pos != null) {
            return (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)(direction != null ? direction : Direction.NORTH));
        }
        return null;
    }

    public static int moveItem(IItemHandler inventoryFrom, IItemHandler inventoryTo, ItemFilter filter) {
        ItemInserter inserter;
        if (inventoryFrom == null) {
            return 0;
        }
        int fromSlot = filter.getFromSlot();
        int toSlot = filter.getToSlot();
        if (!(inventoryFrom instanceof IStorageSystemItemHandler) && fromSlot >= inventoryFrom.getSlots()) {
            return 0;
        }
        if (!(inventoryTo instanceof IStorageSystemItemHandler) && toSlot >= inventoryTo.getSlots()) {
            return 0;
        }
        int needs = filter.getCount();
        if (needs <= 0) {
            return 0;
        }
        if (inventoryTo instanceof IStorageSystemItemHandler) {
            IStorageSystemItemHandler storageTo = (IStorageSystemItemHandler)inventoryTo;
            v0 = stack -> storageTo.insertItem(stack, false);
        } else {
            v0 = inserter = toSlot < 0 ? stack -> ItemHandlerHelper.insertItem((IItemHandler)inventoryTo, (ItemStack)stack, (boolean)false) : stack -> inventoryTo.insertItem(toSlot, stack, false);
        }
        if (inventoryFrom instanceof IStorageSystemItemHandler) {
            IStorageSystemItemHandler storageFrom = (IStorageSystemItemHandler)inventoryFrom;
            return storageFrom.extractItems(filter, extracted -> extracted.getCount() - inserter.insertItem((ItemStack)extracted).getCount(), false);
        }
        int[] fromSlots = (fromSlot >= 0 ? IntStream.of(fromSlot) : IntStream.range(0, inventoryFrom.getSlots())).filter(i -> filter.test(inventoryFrom.getStackInSlot(i))).toArray();
        if (fromSlots.length == 0) {
            return 0;
        }
        for (int i2 : fromSlots) {
            ItemStack extracted2 = inventoryFrom.extractItem(i2, needs, true);
            if (extracted2.isEmpty()) continue;
            ItemStack remaining = inserter.insertItem(extracted2);
            int inserted = extracted2.getCount() - remaining.getCount();
            if (inserted == 0) continue;
            inventoryFrom.extractItem(i2, inserted, false);
            if ((needs -= inserted) <= 0) break;
        }
        return filter.getCount() - needs;
    }

    @Nullable
    public static IItemHandler getHandlerFromName(@NotNull IComputerAccess access, String name) throws LuaException {
        IPeripheral location = access.getAvailablePeripheral(name);
        if (location == null) {
            return null;
        }
        return InventoryUtil.extractHandler(location.getTarget(), null, null, null);
    }

    @Nullable
    public static IItemHandler getHandlerFromDirection(@NotNull String direction, @NotNull IPeripheralOwner owner) throws LuaException {
        Level level = Objects.requireNonNull(owner.getLevel());
        Direction relativeDirection = CoordUtil.getDirection(owner.getOrientation(), direction);
        if (relativeDirection == null) {
            return null;
        }
        BlockEntity target = level.getBlockEntity(owner.getPos().relative(relativeDirection));
        if (target == null) {
            return null;
        }
        return InventoryUtil.extractHandler(target, level, target.getBlockPos(), relativeDirection.getOpposite());
    }

    @FunctionalInterface
    private static interface ItemInserter {
        public ItemStack insertItem(ItemStack var1);
    }
}

