/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.affix.AffixType;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.LinkedHashSet;
import java.util.Set;
import org.spongepowered.include.com.google.common.base.Preconditions;

public record AffixDefinition(AffixType type, Set<DynamicHolder<Affix>> exclusiveSet, TieredWeights weights) {
    public static final Codec<AffixDefinition> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(inst -> inst.group((App)AffixType.CODEC.fieldOf("affix_type").forGetter(AffixDefinition::type), (App)PlaceboCodecs.setOf((Codec)AffixRegistry.INSTANCE.holderCodec()).fieldOf("exclusive_set").forGetter(AffixDefinition::exclusiveSet), (App)TieredWeights.CODEC.fieldOf("weights").forGetter(AffixDefinition::weights)).apply((Applicative)inst, AffixDefinition::new)));

    public static Builder builder(AffixType type) {
        return new Builder(type);
    }

    public static class Builder {
        private final AffixType type;
        private final Set<DynamicHolder<Affix>> exclusiveSet = new LinkedHashSet<DynamicHolder<Affix>>();
        private TieredWeights weights;

        public Builder(AffixType type) {
            this.type = type;
        }

        public Builder exclusiveWith(DynamicHolder<Affix> affix) {
            this.exclusiveSet.add(affix);
            return this;
        }

        public Builder weights(TieredWeights weights) {
            this.weights = weights;
            return this;
        }

        public AffixDefinition build() {
            Preconditions.checkNotNull((Object)this.weights);
            return new AffixDefinition(this.type, this.exclusiveSet, this.weights);
        }
    }
}

