/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.systems.wanderer.WandererTrade;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class AutomaticAffixTrade
implements WandererTrade {
    public static Codec<AutomaticAffixTrade> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PlaceboCodecs.setOf(LootRarity.CODEC).optionalFieldOf("rarities", Set.of()).forGetter(a -> a.rarities), (App)AffixLootRegistry.INSTANCE.holderCodec().listOf().fieldOf("entries").forGetter(a -> a.entries), (App)Codec.BOOL.optionalFieldOf("rare", (Object)false).forGetter(trade -> trade.rare)).apply((Applicative)inst, AutomaticAffixTrade::new));
    protected final Set<LootRarity> rarities;
    protected final List<DynamicHolder<AffixLootEntry>> entries;
    protected final boolean rare;

    public AutomaticAffixTrade(Set<LootRarity> rarities, List<DynamicHolder<AffixLootEntry>> entries, boolean rare) {
        this.rarities = rarities;
        this.entries = entries;
        this.rare = rare;
    }

    @Nullable
    public MerchantOffer getOffer(Entity trader, RandomSource rand) {
        ItemStack affixItem;
        if (trader.level().isClientSide) {
            return null;
        }
        Player player = trader.level().getNearestPlayer(trader, -1.0);
        if (player == null) {
            return null;
        }
        GenContext ctx = GenContext.forPlayer(rand, player);
        if (this.entries.isEmpty()) {
            LootRarity selectedRarity = LootRarity.random(ctx, this.rarities);
            affixItem = LootController.createRandomLootItem(ctx, selectedRarity);
        } else {
            List<WeightedEntry.Wrapper> resolved = this.entries.stream().map(this::unwrap).filter(Objects::nonNull).map(e -> e.wrap(ctx.tier(), ctx.luck())).toList();
            AffixLootEntry entry = (AffixLootEntry)((WeightedEntry.Wrapper)WeightedRandom.getRandomItem((RandomSource)rand, resolved).get()).data();
            LootRarity selectedRarity = LootRarity.random(ctx, this.rarities.isEmpty() ? entry.rarities() : this.rarities);
            affixItem = LootController.createLootItem(entry.stack(), selectedRarity, ctx);
        }
        if (affixItem.isEmpty()) {
            return null;
        }
        affixItem.set(Apoth.Components.FROM_TRADER, (Object)true);
        ItemStack repairMat = this.getRepairMaterial(affixItem);
        if (repairMat.isEmpty()) {
            Apotheosis.LOGGER.trace("An AutomaticAffixTrade was unable to determine a repair material for the item {}!", (Object)affixItem);
            return null;
        }
        ItemCost price2 = new ItemCost((ItemLike)Items.EMERALD, ctx.tier().ordinal() * 7 + 1);
        return new MerchantOffer(new ItemCost((ItemLike)repairMat.getItem(), 5), Optional.of(price2), affixItem, 1, 100, 1.0f);
    }

    public boolean isRare() {
        return this.rare;
    }

    public Codec<? extends WandererTrade> getCodec() {
        return CODEC;
    }

    private AffixLootEntry unwrap(DynamicHolder<AffixLootEntry> holder) {
        if (!holder.isBound()) {
            Apotheosis.LOGGER.error("An AffixTrade failed to resolve the Affix Loot Entry {}!", (Object)holder.getId());
            return null;
        }
        return (AffixLootEntry)holder.get();
    }

    private ItemStack getRepairMaterial(ItemStack stack) {
        Item item = stack.getItem();
        Objects.requireNonNull(item);
        Item item2 = item;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TieredItem.class, ArmorItem.class, ShieldItem.class}, (Object)item2, n)) {
            case 0: {
                TieredItem tiered = (TieredItem)item2;
                ItemStack[] repairItems = tiered.getTier().getRepairIngredient().getItems();
                return repairItems.length > 0 ? repairItems[0] : ItemStack.EMPTY;
            }
            case 1: {
                ArmorItem armor = (ArmorItem)item2;
                ItemStack[] armorRepairItems = ((Ingredient)((ArmorMaterial)armor.getMaterial().value()).repairIngredient().get()).getItems();
                return armorRepairItems.length > 0 ? armorRepairItems[0] : ItemStack.EMPTY;
            }
            case 2: {
                ShieldItem shield = (ShieldItem)item2;
                return shield == Items.SHIELD ? Items.OAK_PLANKS.getDefaultInstance() : ItemStack.EMPTY;
            }
        }
        return ItemStack.EMPTY;
    }
}

