/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.client;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.client.SimpleTexButton;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apotheosis.tiers.augments.TierAugment;
import dev.shadowsoffire.apotheosis.tiers.augments.TierAugmentRegistry;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class WorldTierDetailScreen
extends Screen {
    public static final ResourceLocation TEXTURE = Apotheosis.loc("textures/gui/detail_column.png");
    public static final int BOX_WIDTH = 138;
    public static final int BOX_HEIGHT = 225;
    protected final WorldTier tier;

    protected WorldTierDetailScreen(WorldTier tier) {
        super((Component)Apotheosis.lang("title", "world_tier_details", new Object[0]));
        this.tier = tier;
    }

    protected void init() {
        int leftPos = (this.width - 480) / 2;
        int topPos = (this.height - 270) / 2;
        this.addRenderableWidget((GuiEventListener)SimpleTexButton.builder().size(20, 20).pos(leftPos + 480 - 15, topPos - 5).texture(SimpleTexButton.APOTH_SPRITES).action(btn -> Minecraft.getInstance().popGuiLayer()).buttonText((Component)Apotheosis.lang("button", "return", new Object[0])).message((Component)Apotheosis.lang("button", "return.desc", new Object[0])).build());
    }

    public void renderBackground(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(gfx, mouseX, mouseY, partialTick);
        int leftPos = (this.width - 498) / 2 + 26;
        int topPos = (this.height - 286) / 2 + 30;
        LocalPlayer player = Minecraft.getInstance().player;
        AttributeTooltipContext ctx = AttributeTooltipContext.of((Player)player, (Item.TooltipContext)Item.TooltipContext.of((Level)player.level()), (TooltipFlag)ApothicAttributes.getTooltipFlag());
        for (int i = 0; i < 3; ++i) {
            Object comp;
            MutableComponent header;
            int y;
            int x;
            gfx.blit(TEXTURE, leftPos + i * 154, topPos, 0.0f, 0.0f, 138, 225, 138, 225);
            if (i == 2) {
                x = leftPos + i * 154;
                y = topPos;
                header = Apotheosis.lang("text", "monster_augments", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
                gfx.drawCenteredString(this.font, (Component)header, x + 69, y + 12, 0);
                y += 20;
                for (TierAugment aug : TierAugmentRegistry.getAugments(this.tier, TierAugment.Target.MONSTERS)) {
                    comp = aug.getDescription(ctx).plainCopy().withStyle(ChatFormatting.RED);
                    this.drawScrollingStringWithoutMoving(gfx, this.font, (Component)comp, x + 12, x + 138 - 12, y += 12, 0);
                }
                continue;
            }
            if (i == 1) {
                x = leftPos + i * 154;
                y = topPos;
                header = Apotheosis.lang("text", "player_augments", new Object[0]).withColor(43775).withStyle(ChatFormatting.BOLD);
                gfx.drawCenteredString(this.font, (Component)header, x + 69, y + 12, 0);
                y += 20;
                for (TierAugment aug : TierAugmentRegistry.getAugments(this.tier, TierAugment.Target.PLAYERS)) {
                    comp = aug.getDescription(ctx).plainCopy().withColor(43775);
                    this.drawScrollingStringWithoutMoving(gfx, this.font, (Component)comp, x + 12, x + 138 - 12, y += 12, 0);
                }
                continue;
            }
            if (i != 0) continue;
            x = leftPos + i * 154;
            y = topPos;
            header = Apotheosis.lang("text", "drop_chances", new Object[0]).withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD);
            gfx.drawCenteredString(this.font, (Component)header, x + 69, y + 12, 0);
            MutableComponent rarityHeader = Apotheosis.lang("text", "rarities", new Object[0]).withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.UNDERLINE);
            gfx.drawCenteredString(this.font, (Component)rarityHeader, x + 69, y + 33, 0);
            y += 35;
            int totalWeight = RarityRegistry.INSTANCE.getValues().stream().mapToInt(r -> r.weights().getWeight(this.tier, 0.0f)).sum();
            for (LootRarity rarity : RarityRegistry.getSortedRarities()) {
                float percent = (float)rarity.weights().getWeight(this.tier, 0.0f) / (float)totalWeight;
                MutableComponent comp2 = rarity.toComponent();
                comp2.append((Component)Component.translatable((String)": %s", (Object[])new Object[]{Affix.fmt(100.0f * percent) + "%"}).withStyle(s -> s.withColor(rarity.color())));
                this.drawScrollingStringWithoutMoving(gfx, this.font, (Component)comp2, x + 12, x + 138 - 12, y += 12, 0xFFFFFF);
            }
            MutableComponent purityHeader = Apotheosis.lang("text", "purities", new Object[0]).withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.UNDERLINE);
            gfx.drawCenteredString(this.font, (Component)purityHeader, x + 69, y + 13, 0);
            y += 15;
            Purity[] values = Purity.values();
            totalWeight = Arrays.stream(values).mapToInt(r -> r.weights().getWeight(this.tier, 0.0f)).sum();
            for (Purity purity : values) {
                float percent = (float)purity.weights().getWeight(this.tier, 0.0f) / (float)totalWeight;
                MutableComponent comp3 = purity.toComponent();
                comp3.append((Component)Component.translatable((String)": %s", (Object[])new Object[]{Affix.fmt(100.0f * percent) + "%"}).withStyle(s -> s.withColor(purity.getColor())));
                this.drawScrollingStringWithoutMoving(gfx, this.font, (Component)comp3, x + 12, x + 138 - 12, y += 12, 0xFFFFFF);
            }
        }
    }

    int drawScrollingStringWithoutMoving(GuiGraphics gfx, Font font, Component text, int minX, int maxX, int y, int color) {
        int maxWidth = maxX - minX;
        int textWidth = font.width(text.getVisualOrderText());
        if (textWidth <= maxWidth) {
            return gfx.drawString(font, text, minX, y, color);
        }
        Objects.requireNonNull(font);
        AbstractWidget.renderScrollingString((GuiGraphics)gfx, (Font)font, (Component)text, (int)minX, (int)(y - 1), (int)maxX, (int)(y + 9), (int)color);
        return maxWidth;
    }
}

