/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat.gateways;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.mobs.registries.EliteRegistry;
import dev.shadowsoffire.apotheosis.mobs.types.Elite;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public record EliteWaveEntity(WaveEntity base, DynamicHolder<Elite> elite, Optional<String> desc) implements WaveEntity
{
    public static Codec<EliteWaveEntity> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)WaveEntity.CODEC.fieldOf("base_entity").forGetter(EliteWaveEntity::base), (App)EliteRegistry.INSTANCE.holderCodec().fieldOf("elite").forGetter(EliteWaveEntity::elite), (App)Codec.STRING.optionalFieldOf("desc").forGetter(EliteWaveEntity::desc)).apply((Applicative)inst, EliteWaveEntity::new));

    public LivingEntity createEntity(ServerLevel level, GatewayEntity gate) {
        LivingEntity baseEntity = this.base.createEntity(level, gate);
        if (baseEntity == null) {
            return null;
        }
        if (!this.elite.isBound()) {
            Apotheosis.LOGGER.error("An EliteWaveEntity has an ubound elite holder {}!", this.elite);
            return null;
        }
        if (baseEntity instanceof Mob) {
            Mob mob = (Mob)baseEntity;
            mob.getPersistentData().putString("apoth.miniboss", this.elite.getId().toString());
            mob.getPersistentData().putString("apoth.miniboss.player", gate.summonerOrClosest().getUUID().toString());
            return baseEntity;
        }
        Apotheosis.LOGGER.error("An EliteWaveEntity tried to apply an elite to a non-Mob entity: {}!", (Object)baseEntity);
        return baseEntity;
    }

    public MutableComponent getDescription() {
        if (this.desc.isPresent()) {
            return Component.translatable((String)this.desc.get(), (Object[])new Object[]{this.base.getDescription()});
        }
        return Apotheosis.lang("wave_entity", "elite", this.base.getDescription());
    }

    public boolean shouldFinalizeSpawn() {
        return false;
    }

    public Codec<? extends WaveEntity> getCodec() {
        return CODEC;
    }

    public int getCount() {
        return this.base.getCount();
    }
}

