/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.loot;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apothic_attributes.modifiers.EntitySlotGroup;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.callback.BakeCallback;
import org.jetbrains.annotations.ApiStatus;

public final class LootCategory {
    public static final Codec<LootCategory> CODEC = Codec.lazyInitialized(() -> LootCategory.legacyResolverCodec());
    public static final Codec<LootCategory> OPTIONAL_CODEC = Codec.lazyInitialized(() -> Apoth.BuiltInRegs.LOOT_CATEGORY.byNameCodec());
    public static final Codec<Set<LootCategory>> SET_CODEC = PlaceboCodecs.setOf(CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, LootCategory> STREAM_CODEC = ByteBufCodecs.registry((ResourceKey)Apoth.BuiltInRegs.LOOT_CATEGORY.key());
    private static List<LootCategory> sortedCategories = new ArrayList<LootCategory>();
    private final Predicate<ItemStack> validator;
    private final EntitySlotGroup slots;
    private final int priority;
    @Nullable
    private String descId;

    public LootCategory(Predicate<ItemStack> validator, EntitySlotGroup slots, int priority) {
        this.validator = (Predicate)Preconditions.checkNotNull(validator);
        this.slots = (EntitySlotGroup)Preconditions.checkNotNull((Object)slots);
        this.priority = priority;
    }

    public LootCategory(Predicate<ItemStack> validator, EntitySlotGroup slots) {
        this(validator, slots, 1000);
    }

    public String getDescId() {
        return this.getOrCreateDescriptionId();
    }

    public String getDescIdPlural() {
        return this.getDescId() + ".plural";
    }

    public ResourceLocation getKey() {
        return Apoth.BuiltInRegs.LOOT_CATEGORY.getKey((Object)this);
    }

    public int priority() {
        return this.priority;
    }

    public EntitySlotGroup getSlots() {
        return this.slots;
    }

    public boolean isValid(ItemStack stack) {
        return this.validator.test(stack);
    }

    @Deprecated(forRemoval=true)
    public boolean isArmor() {
        return this == Apoth.LootCategories.HELMET || this == Apoth.LootCategories.CHESTPLATE || this == Apoth.LootCategories.LEGGINGS || this == Apoth.LootCategories.BOOTS;
    }

    @Deprecated(forRemoval=true)
    public boolean isBreaker() {
        return this == Apoth.LootCategories.BREAKER;
    }

    @Deprecated(forRemoval=true)
    public boolean isRanged() {
        return this == Apoth.LootCategories.BOW || this == Apoth.LootCategories.TRIDENT;
    }

    @Deprecated(forRemoval=true)
    public boolean isDefensive() {
        return this.isArmor() || this == Apoth.LootCategories.SHIELD;
    }

    @Deprecated(forRemoval=true)
    public boolean isMelee() {
        return this == Apoth.LootCategories.MELEE_WEAPON || this == Apoth.LootCategories.TRIDENT;
    }

    @Deprecated(forRemoval=true)
    public boolean isMeleeOrShield() {
        return this.isMelee() || this == Apoth.LootCategories.SHIELD;
    }

    public boolean isNone() {
        return this == Apoth.LootCategories.NONE;
    }

    public String toString() {
        return String.format("LootCategory[%s]", this.getKey());
    }

    protected String getOrCreateDescriptionId() {
        if (this.descId == null) {
            this.descId = Util.makeDescriptionId((String)"loot_category", (ResourceLocation)this.getKey());
        }
        return this.descId;
    }

    public static <T> MapCodec<Map<LootCategory, T>> mapCodec(Codec<T> codec) {
        return Codec.simpleMap(CODEC, codec, arg_0 -> Apoth.BuiltInRegs.LOOT_CATEGORY.keys(arg_0));
    }

    public static LootCategory forItem(ItemStack stack) {
        if (sortedCategories.isEmpty()) {
            throw new UnsupportedOperationException("Attempted to resolve the loot category for an item before loot categories were registered!");
        }
        if (stack.isEmpty()) {
            return Apoth.LootCategories.NONE;
        }
        LootCategory override = (LootCategory)BuiltInRegistries.ITEM.getData(Apoth.DataMaps.LOOT_CATEGORY_OVERRIDES, stack.getItemHolder().getKey());
        if (override != null) {
            return override;
        }
        for (LootCategory c : sortedCategories) {
            if (!c.isValid(stack)) continue;
            return c;
        }
        return Apoth.LootCategories.NONE;
    }

    @Deprecated(forRemoval=true)
    private static Codec<LootCategory> legacyResolverCodec() {
        return Codec.either((Codec)Codec.stringResolver(ResourceLocation::getPath, LootCategory::readLocWithApothNamespace), (Codec)ResourceLocation.CODEC).xmap(Either::unwrap, Either::right).xmap(arg_0 -> Apoth.BuiltInRegs.LOOT_CATEGORY.get(arg_0), arg_0 -> Apoth.BuiltInRegs.LOOT_CATEGORY.getKey(arg_0)).validate(cat -> cat == Apoth.LootCategories.NONE ? DataResult.error(() -> "Loot Category must not be apotheosis:none") : DataResult.success((Object)cat));
    }

    @Nullable
    private static ResourceLocation readLocWithApothNamespace(String path) {
        try {
            return path.contains(":") ? ResourceLocation.parse((String)path) : Apotheosis.loc(path);
        }
        catch (ResourceLocationException resourcelocationexception) {
            return null;
        }
    }

    @ApiStatus.Internal
    public static class Inner {
        public static BakeCallback<LootCategory> rebuildSortedValueList() {
            return registry -> {
                ArrayList<LootCategory> list = new ArrayList<LootCategory>();
                for (LootCategory cat : registry) {
                    list.add(cat);
                }
                Collections.sort(list, Comparator.comparing(LootCategory::priority));
                sortedCategories = list;
            };
        }
    }
}

