/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mobs.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.attachments.BonusLootTables;
import dev.shadowsoffire.apotheosis.mobs.util.SpawnCondition;
import dev.shadowsoffire.apotheosis.mobs.util.SupportingEntity;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apotheosis.util.NameHelper;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import dev.shadowsoffire.placebo.systems.gear.GearSet;
import dev.shadowsoffire.placebo.systems.gear.GearSetRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public record BasicBossData(TieredWeights weights, Constraints constraints, Component name, BonusLootTables bonusLoot, Map<WorldTier, List<GearSet.SetPredicate>> gearSets, Optional<CompoundTag> nbt, Optional<SupportingEntity> mount, List<SupportingEntity> support, boolean finalizeSpawn, List<SpawnCondition> spawnConditions) {
    public static final String NAME_GEN = "use_name_generation";
    public static final Codec<BasicBossData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TieredWeights.CODEC.fieldOf("weights").forGetter(BasicBossData::weights), (App)Constraints.CODEC.optionalFieldOf("constraints", (Object)Constraints.EMPTY).forGetter(BasicBossData::constraints), (App)ComponentSerialization.CODEC.optionalFieldOf("name", (Object)CommonComponents.EMPTY).forGetter(BasicBossData::name), (App)BonusLootTables.CODEC.optionalFieldOf("bonus_loot", (Object)BonusLootTables.EMPTY).forGetter(BasicBossData::bonusLoot), (App)WorldTier.mapCodec(GearSet.SetPredicate.CODEC.listOf()).codec().optionalFieldOf("valid_gear_sets", Map.of()).forGetter(BasicBossData::gearSets), (App)NBTAdapter.EITHER_CODEC.optionalFieldOf("nbt").forGetter(BasicBossData::nbt), (App)SupportingEntity.CODEC.optionalFieldOf("mount").forGetter(BasicBossData::mount), (App)SupportingEntity.CODEC.listOf().optionalFieldOf("supporting_entities", Collections.emptyList()).forGetter(BasicBossData::support), (App)Codec.BOOL.optionalFieldOf("finalize", (Object)false).forGetter(BasicBossData::finalizeSpawn), (App)SpawnCondition.CODEC.listOf().optionalFieldOf("spawn_conditions", Collections.emptyList()).forGetter(BasicBossData::spawnConditions)).apply((Applicative)inst, BasicBossData::new));
    public static final Codec<AABB> AABB_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.DOUBLE.fieldOf("width").forGetter(a -> Math.abs(a.maxX - a.minX)), (App)Codec.DOUBLE.fieldOf("height").forGetter(a -> Math.abs(a.maxY - a.minY))).apply((Applicative)inst, (width, height) -> new AABB(0.0, 0.0, 0.0, width.doubleValue(), height.doubleValue(), width.doubleValue())));

    public boolean hasGearSets(WorldTier tier) {
        return !this.gearSets.getOrDefault((Object)tier, List.of()).isEmpty();
    }

    public boolean hasNbt() {
        return this.nbt.isPresent();
    }

    public boolean hasMount() {
        return this.mount.isPresent();
    }

    public void applyEntityName(RandomSource rand, Mob mob) {
        String nameStr = this.name.getString();
        if (NAME_GEN.equals(nameStr)) {
            NameHelper.setEntityName(rand, mob);
        } else if (!nameStr.isBlank()) {
            mob.setCustomName(this.name);
        }
        if (mob.hasCustomName()) {
            mob.setCustomNameVisible(true);
        }
    }

    public void appendBonusLoot(Mob mob) {
        if (!this.bonusLoot.isEmpty()) {
            BonusLootTables existing = (BonusLootTables)mob.getData(Apoth.Attachments.BONUS_LOOT_TABLES);
            mob.setData(Apoth.Attachments.BONUS_LOOT_TABLES, (Object)existing.mergeWith(this.bonusLoot));
        }
    }

    @Nullable
    public GearSet applyGearSet(Mob mob, GenContext ctx) {
        List<GearSet.SetPredicate> sets = this.gearSets.get((Object)ctx.tier());
        if (sets == null || sets.isEmpty()) {
            return null;
        }
        GearSet set = GearSetRegistry.INSTANCE.getRandomSet(ctx.rand(), ctx.luck(), sets);
        if (set != null) {
            set.apply((LivingEntity)mob);
        }
        return set;
    }

    public Mob createMount(ServerLevelAccessor level, BlockPos pos, Mob rider) {
        if (!this.hasMount()) {
            Apotheosis.LOGGER.error("BasicBossData#createMount called when hasMount() was false!");
            return rider;
        }
        Mob mountedEntity = this.mount.get().create((Level)level.getLevel(), (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
        rider.startRiding((Entity)mountedEntity, true);
        return mountedEntity;
    }

    public boolean canSpawn(Mob mob, ServerLevelAccessor level, MobSpawnType type) {
        return SpawnCondition.checkAll(this.spawnConditions, mob, level, type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TieredWeights weights;
        private Constraints constraints = Constraints.EMPTY;
        private Component name = CommonComponents.EMPTY;
        private BonusLootTables bonusLoot = BonusLootTables.EMPTY;
        private Map<WorldTier, List<GearSet.SetPredicate>> gearSets = new HashMap<WorldTier, List<GearSet.SetPredicate>>();
        private Optional<CompoundTag> nbt = Optional.empty();
        private Optional<SupportingEntity> mount = Optional.empty();
        private List<SupportingEntity> support = new ArrayList<SupportingEntity>();
        private boolean finalizeSpawn = false;
        private List<SpawnCondition> exclusions = new ArrayList<SpawnCondition>();

        public Builder weights(TieredWeights weights) {
            this.weights = weights;
            return this;
        }

        public Builder weights(UnaryOperator<TieredWeights.Builder> config) {
            return this.weights(((TieredWeights.Builder)config.apply(TieredWeights.builder())).build());
        }

        public Builder constraints(Constraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public Builder constraints(UnaryOperator<Constraints.Builder> config) {
            return this.constraints(((Constraints.Builder)config.apply(Constraints.builder())).build());
        }

        public Builder name(Component name) {
            this.name = name;
            return this;
        }

        public Builder bonusLoot(BonusLootTables bonusLoot) {
            this.bonusLoot = bonusLoot;
            return this;
        }

        @SafeVarargs
        public final Builder bonusLoot(ResourceKey<LootTable> ... tables) {
            this.bonusLoot = new BonusLootTables(Arrays.asList(tables));
            return this;
        }

        public Builder gearSets(WorldTier tier, String ... sets) {
            this.gearSets.put(tier, Arrays.stream(sets).map(GearSet.SetPredicate::new).toList());
            return this;
        }

        public Builder nbt(CompoundTag nbt) {
            this.nbt = Optional.of(nbt);
            return this;
        }

        public Builder nbt(Consumer<CompoundTag> nbt) {
            CompoundTag current = this.nbt.orElse(new CompoundTag());
            nbt.accept(current);
            this.nbt = Optional.of(current);
            return this;
        }

        public Builder mount(SupportingEntity mount) {
            this.mount = Optional.of(mount);
            return this;
        }

        public Builder mount(UnaryOperator<SupportingEntity.Builder> config) {
            return this.mount(((SupportingEntity.Builder)config.apply(SupportingEntity.builder())).build());
        }

        public Builder support(SupportingEntity support) {
            this.support.add(support);
            return this;
        }

        public Builder support(UnaryOperator<SupportingEntity.Builder> config) {
            return this.support(((SupportingEntity.Builder)config.apply(SupportingEntity.builder())).build());
        }

        public Builder support(List<SupportingEntity> support) {
            this.support = support;
            return this;
        }

        public Builder finalizeSpawn(boolean finalizeSpawn) {
            this.finalizeSpawn = finalizeSpawn;
            return this;
        }

        public Builder exclusion(SpawnCondition exclusion) {
            this.exclusions.add(exclusion);
            return this;
        }

        public Builder exclusions(List<SpawnCondition> exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        public BasicBossData build() {
            if (this.weights == null) {
                throw new IllegalStateException("Weights must be set");
            }
            return new BasicBossData(this.weights, this.constraints, this.name, this.bonusLoot, this.gearSets, this.nbt, this.mount, this.support, this.finalizeSpawn, this.exclusions);
        }
    }
}

