/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.energy;

import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.parts.AEBasePart;
import appeng.parts.PartAdjacentApi;
import com.glodblock.github.appflux.common.me.energy.EnergyCapCache;
import com.glodblock.github.appflux.common.me.energy.EnergyHandler;
import com.glodblock.github.appflux.common.me.energy.EnergyTickRecord;
import com.glodblock.github.appflux.common.me.service.EnergyDistributeService;
import com.glodblock.github.appflux.common.me.service.IEnergyDistributor;
import com.glodblock.github.appflux.util.AFUtil;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.ICapabilityInvalidationListener;
import org.jetbrains.annotations.Nullable;

public class EnergyTicker
implements IEnergyDistributor {
    private EnergyCapCache cache;
    private EnergyDistributeService service;
    private BlockEntity tile;
    private final Supplier<BlockEntity> lazyInit;
    private final Object host;
    private final BooleanSupplier controller;
    private final IManagedGridNode mainNode;
    private final IActionSource source;
    private Set<Direction> validSides;
    private final Set<Direction> blocked = EnumSet.noneOf(Direction.class);
    private final Reference2ReferenceMap<Direction, EnergyTickRecord> lastTick = new Reference2ReferenceOpenHashMap();
    private final ICapabilityInvalidationListener[] listeners = new ICapabilityInvalidationListener[6];

    public EnergyTicker(Supplier<BlockEntity> tileGetter, Object host, BooleanSupplier controller, IManagedGridNode node, IActionSource source) {
        this.lazyInit = tileGetter;
        this.controller = controller;
        this.mainNode = node;
        this.source = source;
        this.host = host;
        for (Direction d : Direction.values()) {
            this.listeners[d.get3DDataValue()] = () -> {
                Object patt0$temp = this.host;
                if (patt0$temp instanceof AEBasePart) {
                    AEBasePart part = (AEBasePart)patt0$temp;
                    if (!PartAdjacentApi.isPartValid((AEBasePart)part)) {
                        return false;
                    }
                } else {
                    Object patt1$temp = this.host;
                    if (patt1$temp instanceof BlockEntity) {
                        BlockEntity te = (BlockEntity)patt1$temp;
                        if (te.isRemoved()) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                this.unblock(d);
                return true;
            };
        }
    }

    @Override
    public boolean isActive() {
        return this.mainNode.isActive();
    }

    @Override
    public void distribute(long ticks) {
        if (this.service == null) {
            return;
        }
        if (this.cache == null) {
            this.initCache();
        }
        if (this.validSides.size() == this.blocked.size()) {
            return;
        }
        IStorageService storage = this.getStorage();
        if (storage != null) {
            for (Direction d : this.validSides) {
                EnergyTickRecord tickRate;
                if (this.blocked.contains(d) || !(tickRate = (EnergyTickRecord)this.lastTick.get((Object)d)).needTick(ticks)) continue;
                long sent = EnergyHandler.send(this.cache, d, storage, this.source);
                if (sent == -1L) {
                    this.blocked.add(d);
                    continue;
                }
                tickRate.sent(sent);
            }
        }
    }

    @Override
    public void setServiceHost(@Nullable EnergyDistributeService service) {
        this.service = service;
        this.updateSleep();
        if (service != null) {
            this.tile = this.lazyInit.get();
            this.validSides = AFUtil.getSides(this.host);
            this.blocked.clear();
            Level level = this.tile.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)level;
                for (Direction d : this.validSides) {
                    BlockPos pos = this.tile.getBlockPos().relative(d);
                    world.registerCapabilityListener(pos, this.listeners[d.get3DDataValue()]);
                    this.lastTick.put((Object)d, (Object)new EnergyTickRecord());
                }
            }
        }
    }

    public void updateSleep() {
        if (this.service != null) {
            if (this.controller.getAsBoolean()) {
                this.service.wake(this);
            } else {
                this.service.sleep(this);
            }
        }
    }

    public void unblock(Direction dir) {
        if (this.validSides.contains(dir)) {
            this.blocked.remove(dir);
        }
    }

    private IStorageService getStorage() {
        if (this.mainNode.getGrid() != null) {
            return this.mainNode.getGrid().getStorageService();
        }
        return null;
    }

    private void initCache() {
        this.cache = new EnergyCapCache((ServerLevel)this.tile.getLevel(), this.tile.getBlockPos(), () -> ((IManagedGridNode)this.mainNode).getGrid());
    }
}

