/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.xmod.mek;

import appeng.api.config.Actionable;
import com.glodblock.github.appflux.util.TileCache;
import com.glodblock.github.appflux.xmod.mek.MekEnergy;
import mekanism.api.Action;
import mekanism.common.content.matrix.MatrixMultiblockData;
import mekanism.common.tile.multiblock.TileEntityInductionPort;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class MekInductionPortHandler
implements MekEnergy {
    private final TileCache cache;

    protected MekInductionPortHandler(ServerLevel level, BlockPos fromPos) {
        this.cache = TileCache.create(level, fromPos);
    }

    @Override
    public boolean valid() {
        return this.cache.find() instanceof TileEntityInductionPort;
    }

    @Override
    public long getStored() {
        if (this.valid()) {
            TileEntityInductionPort port = (TileEntityInductionPort)this.cache.find();
            assert (port != null);
            return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(((MatrixMultiblockData)port.getMultiblock()).getEnergy());
        }
        return 0L;
    }

    @Override
    public long input(long power, Actionable mode, Direction side) {
        if (this.valid()) {
            TileEntityInductionPort port = (TileEntityInductionPort)this.cache.find();
            assert (port != null);
            long add = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(power);
            long left = ((MatrixMultiblockData)port.getMultiblock()).insertEnergy(add, side, Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction()));
            return power - UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(left);
        }
        return 0L;
    }

    @Override
    public long output(long power, Actionable mode, Direction side) {
        if (this.valid()) {
            TileEntityInductionPort port = (TileEntityInductionPort)this.cache.find();
            assert (port != null);
            long drain = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(power);
            long left = ((MatrixMultiblockData)port.getMultiblock()).extractEnergy(drain, side, Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction()));
            return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(left);
        }
        return 0L;
    }
}

