/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui.widgets;

import com.mrbysco.armorposer.Reference;
import com.mrbysco.armorposer.client.gui.ArmorPosesScreen;
import com.mrbysco.armorposer.client.gui.widgets.PoseEntry;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PoseListWidget
extends ObjectSelectionList<ListEntry> {
    private static final Vector3f ARMOR_STAND_TRANSLATION = new Vector3f();
    private static final Quaternionf ARMOR_STAND_ANGLE = new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI);
    private final ArmorPosesScreen parent;
    private final int listWidth;
    private final Component title;

    public PoseListWidget(ArmorPosesScreen parent, Component title, boolean user, int listWidth, int top, int bottom) {
        Minecraft minecraft = parent.getScreenMinecraft();
        Objects.requireNonNull(parent.getScreenFont());
        super(minecraft, listWidth, bottom - top, top, 9 * 2 + 16);
        this.parent = parent;
        this.title = title;
        this.listWidth = listWidth;
        this.refreshList(user);
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.listWidth - 6;
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    public void refreshList(boolean user) {
        this.clearEntries();
        if (user) {
            this.parent.buildUserPoseList(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0), location -> new ListEntry((PoseEntry)location, this.parent));
        } else {
            this.parent.buildPoseList(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0), location -> new ListEntry((PoseEntry)location, this.parent));
        }
    }

    protected void renderSelection(GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
        int xPos = this.getX() + (this.width - width) / 2;
        int xPos2 = this.getX() + (this.width + width) / 2;
        guiGraphics.fillGradient(xPos, top - 2, xPos2, top + height + 2, -1945083888, -1676648432);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fillGradient(this.getX(), 0, this.getX() + this.listWidth, this.parent.height, -1945104368, -1676668912);
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.parent.getScreenFont(), this.title, this.getX() + this.listWidth / 2, 2, 0xFFFFFF);
    }

    public class ListEntry
    extends ObjectSelectionList.Entry<ListEntry> {
        private final PoseEntry poseEntry;
        private final ArmorPosesScreen parent;
        private LivingEntity cachedEntity;

        ListEntry(PoseEntry entry, ArmorPosesScreen parent) {
            ClientLevel level;
            this.poseEntry = entry;
            this.parent = parent;
            Minecraft mc = parent.getScreenMinecraft();
            if (mc == null) {
                Reference.LOGGER.error("Minecraft is null, cannot create pose entry {}", (Object)entry.pose().name());
                return;
            }
            Object object = level = mc.hasSingleplayerServer() && mc.getSingleplayerServer() != null ? (Level)mc.getSingleplayerServer().getAllLevels().iterator().next() : mc.level;
            if (level != null) {
                try {
                    ArmorStand armorStand;
                    CompoundTag tag = TagParser.parseTag((String)entry.pose().data());
                    CompoundTag nbt = new CompoundTag();
                    nbt.putString("id", "minecraft:armor_stand");
                    if (!tag.isEmpty()) {
                        nbt.merge(tag);
                    }
                    if ((armorStand = (ArmorStand)EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)level, Function.identity())) != null) {
                        armorStand.setNoBasePlate(true);
                        armorStand.setShowArms(true);
                        armorStand.yBodyRot = 210.0f;
                        armorStand.setXRot(25.0f);
                        armorStand.yHeadRot = armorStand.getYRot();
                        armorStand.yHeadRotO = armorStand.getYRot();
                        this.cachedEntity = armorStand;
                    }
                }
                catch (Exception e) {
                    Reference.LOGGER.error("Unable to parse nbt pose {}", (Object)e.getMessage());
                }
            }
        }

        public void render(GuiGraphics guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Font font = this.parent.getScreenFont();
            AbstractWidget.renderScrollingString((GuiGraphics)guiGraphics, (Font)font, (Component)Component.literal((String)this.getName()), (int)(left + 36), (int)(top + 10), (int)(left + PoseListWidget.this.width - 18), (int)(top + 20), (int)0xFFFFFF);
            this.renderPose(guiGraphics, left + 16, top + 28, 15);
        }

        public void renderPose(GuiGraphics guiGraphics, int xPos, int yPos, int size) {
            if (this.cachedEntity != null) {
                InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)xPos, (float)yPos, (float)size, (Vector3f)ARMOR_STAND_TRANSLATION, (Quaternionf)ARMOR_STAND_ANGLE, (Quaternionf)null, (LivingEntity)this.cachedEntity);
            }
        }

        public void renderBack(GuiGraphics guiGraphics, int mouseX, int mouseY, int $$3, int $$4, int $$5, int $$6, int $$7, boolean $$8, float $$9) {
            super.renderBack(guiGraphics, mouseX, mouseY, $$3, $$4, $$5, $$6, $$7, $$8, $$9);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            this.parent.setSelected(this);
            if (PoseListWidget.this.getSelected() == this) {
                PoseListWidget.this.setSelected(null);
            } else {
                PoseListWidget.this.setSelected((AbstractSelectionList.Entry)this);
            }
            return false;
        }

        public CompoundTag getTag() {
            return this.poseEntry.getTag();
        }

        public String getName() {
            return this.poseEntry.getName();
        }

        public boolean userAdded() {
            return this.poseEntry.userAdded();
        }

        public String rawName() {
            return this.poseEntry.pose().name();
        }

        public Component getNarration() {
            return Component.literal((String)this.getName());
        }
    }
}

