/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.backupmanager.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.creeperhost.backupmanager.BackupManager;
import net.creeperhost.backupmanager.providers.BackupException;
import net.minecraft.FileUtil;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import org.apache.commons.io.IOUtils;

public interface Backup {
    public String backupLocation();

    public String name();

    public String displayName();

    public long creationTime();

    public String backupProvider();

    default public List<Component> hoverText() {
        return Collections.emptyList();
    }

    default public List<Component> infoText() {
        return Collections.emptyList();
    }

    public void delete() throws BackupException;

    public void restore(String var1) throws BackupException;

    default public void clear() {
        if (this.getIcon() != null) {
            this.getIcon().close();
            this.setIcon(null);
        }
    }

    public FaviconTexture getIcon();

    public void setIcon(FaviconTexture var1);

    default public String getWorldFolderName(String worldName) throws BackupException {
        if ((worldName = worldName.trim()).isEmpty()) {
            throw new BackupException((Component)Component.literal((String)"World name can not be empty!"));
        }
        Path savesFolder = BackupManager.getSavesPath();
        try {
            return FileUtil.findAvailableName((Path)savesFolder, (String)worldName, (String)"");
        }
        catch (Exception ex) {
            BackupManager.LOGGER.error("Could not create save folder!", (Throwable)ex);
            throw new BackupException((Component)Component.literal((String)("Could not create save folder! " + ex.getMessage())));
        }
    }

    default public void unzip(Path zipFile, Path outputFolder) throws BackupException {
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(zipFile, new OpenOption[0]));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                Path newFile = outputFolder.resolve(zipEntry.getName());
                if (!newFile.startsWith(outputFolder)) {
                    BackupManager.LOGGER.error("Entry is outside of the target dir: " + zipEntry.getName());
                    throw new BackupException((Component)Component.literal((String)"Invalid zip file"));
                }
                if (zipEntry.isDirectory()) {
                    if (!Files.isDirectory(newFile, new LinkOption[0])) {
                        Files.createDirectories(newFile, new FileAttribute[0]);
                    }
                } else {
                    Path parent = newFile.getParent();
                    if (!Files.isDirectory(parent, new LinkOption[0])) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    try (OutputStream fos = Files.newOutputStream(newFile, new OpenOption[0]);){
                        IOUtils.copy((InputStream)zis, (OutputStream)fos);
                    }
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
        catch (Throwable e) {
            BackupManager.LOGGER.error("En error occurred while trying to unzip file: {}", (Object)zipFile.toAbsolutePath().toString(), (Object)e);
            throw new BackupException((Component)Component.literal((String)"Failed to unzip file. See log for details."));
        }
    }

    default public Path getTempDirectory() throws BackupException {
        Path tempPath;
        int i = 0;
        do {
            tempPath = BackupManager.getSavesPath().resolve(".backup-extract." + i + ".temp");
            if (++i <= 1000) continue;
            throw new BackupException((Component)Component.literal((String)"Failed to create temp file after 1000 attempts."));
        } while (Files.exists(tempPath, new LinkOption[0]) || Files.isDirectory(tempPath, new LinkOption[0]));
        return tempPath;
    }

    default public void setWorldName(Path worldFolder, String name) throws BackupException {
        Path levelDat = worldFolder.resolve("level.dat");
        if (!Files.exists(levelDat, new LinkOption[0])) {
            throw new BackupException((Component)Component.literal((String)"Failed to set world name because level.dat file could not be found!"));
        }
        try {
            CompoundTag levelTag = NbtIo.readCompressed((Path)levelDat, (NbtAccounter)NbtAccounter.unlimitedHeap());
            CompoundTag data = levelTag.getCompound("Data");
            if (!data.contains("LevelName")) {
                throw new BackupException((Component)Component.literal((String)"Failed to set world name because level.dat file is not valid"));
            }
            data.putString("LevelName", name);
            NbtIo.writeCompressed((CompoundTag)levelTag, (Path)levelDat);
        }
        catch (IOException ex) {
            BackupManager.LOGGER.error("An error occurred while attempting to update level.dat", (Throwable)ex);
            throw new BackupException((Component)Component.literal((String)"An error occurred while attempting to update level.dat"));
        }
    }

    default public void smartMove(Path extractedBackup, Path worldFolder) throws BackupException {
        Path worldPath = extractedBackup;
        try {
            while (!Files.exists(worldPath.resolve("level.dat"), new LinkOption[0])) {
                List<Path> subDirs = Files.list(worldPath).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).toList();
                if (subDirs.size() == 1) {
                    worldPath = subDirs.get(0);
                    continue;
                }
                throw new BackupException((Component)Component.literal((String)"Could not locate level.dat file inside the extracted backup."));
            }
            Files.move(worldPath, worldFolder, new CopyOption[0]);
        }
        catch (IOException e) {
            BackupManager.LOGGER.error("An error occurred while attempting to move extracted world!" + String.valueOf(e));
            throw new BackupException((Component)Component.literal((String)"An error occurred while attempting to move extracted world!"));
        }
    }
}

