/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.backupmanager.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.creeperhost.backupmanager.BackupManager;
import net.creeperhost.backupmanager.providers.Backup;
import net.creeperhost.backupmanager.providers.BackupException;
import net.creeperhost.backupmanager.providers.BackupProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.network.chat.Component;
import org.apache.commons.io.FileUtils;

public class FTBBackupProvider
implements BackupProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    @Override
    public List<Backup> getBackups() {
        BackupsStore backupsStore = FTBBackupProvider.readBackupsJson();
        if (backupsStore == null) {
            return Collections.emptyList();
        }
        FileSystem fileSystem = FileSystems.getDefault();
        ArrayList<Backup> results = new ArrayList<Backup>();
        for (FTBBackup backup : backupsStore.backups) {
            Path path = fileSystem.getPath(backup.backupLocation, new String[0]);
            if (!backup.complete || !Files.exists(path, new LinkOption[0])) continue;
            if (backup.snapshot) {
                backup.info.add((Component)Component.literal((String)"Snapshot").withStyle(ChatFormatting.YELLOW));
            }
            results.add(backup);
        }
        return results;
    }

    private static BackupsStore readBackupsJson() {
        BackupsStore backupsStore;
        Path directory = BackupManager.getMcPath().resolve("backups");
        Path json = directory.resolve("backups.json");
        if (!Files.isDirectory(directory, new LinkOption[0]) || !Files.exists(json, new LinkOption[0])) {
            return null;
        }
        FileReader reader = new FileReader(json.toFile());
        try {
            backupsStore = (BackupsStore)GSON.fromJson((Reader)reader, BackupsStore.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                BackupManager.LOGGER.error("An error occurred loading FTB backups json {}", (Object)json.toAbsolutePath().toAbsolutePath(), (Object)e);
                return null;
            }
        }
        reader.close();
        return backupsStore;
    }

    private static boolean writeBackupsJson(BackupsStore store) {
        Path directory = BackupManager.getMcPath().resolve("backups");
        Path json = directory.resolve("backups.json");
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return false;
        }
        try (FileWriter writer = new FileWriter(json.toFile());){
            GSON.toJson((Object)store, (Appendable)writer);
        }
        catch (Exception e) {
            BackupManager.LOGGER.error("An error occurred loading FTB backups json {}", (Object)json.toAbsolutePath().toAbsolutePath(), (Object)e);
            return false;
        }
        return true;
    }

    private static class BackupsStore {
        private List<FTBBackup> backups = new ArrayList<FTBBackup>();

        private BackupsStore() {
        }
    }

    public static class FTBBackup
    implements Backup {
        private String worldName;
        private long createTime;
        private String backupLocation;
        private long size;
        private float ratio;
        public String sha1;
        public String preview;
        private boolean snapshot;
        private String backupName;
        private Format backupFormat;
        private boolean complete;
        private transient List<Component> info = new ArrayList<Component>();
        private transient FaviconTexture icon = null;

        @Override
        public List<Component> hoverText() {
            return List.of(Component.translatable((String)"backupmanager:gui.backups.file_location"), Component.literal((String)this.backupLocation).withStyle(ChatFormatting.GRAY));
        }

        @Override
        public String backupLocation() {
            return this.backupLocation;
        }

        @Override
        public String name() {
            return this.worldName;
        }

        @Override
        public String displayName() {
            return this.backupName;
        }

        @Override
        public long creationTime() {
            return this.createTime;
        }

        @Override
        public String backupProvider() {
            return String.valueOf(ChatFormatting.GREEN) + "FTB Backups 2";
        }

        @Override
        public List<Component> infoText() {
            return this.info;
        }

        @Override
        public void delete() throws BackupException {
            BackupsStore backupsStore = FTBBackupProvider.readBackupsJson();
            if (backupsStore == null) {
                throw new BackupException((Component)Component.literal((String)"Failed to read backups json file."));
            }
            if (this.backupFormat != Format.ZIP) {
                throw new BackupException((Component)Component.literal((String)("Backup manager currently only supports backups using the zip format! (Found: " + String.valueOf((Object)this.backupFormat) + ")")));
            }
            File backup = new File(this.backupLocation);
            if (!backup.isFile()) {
                throw new BackupException((Component)Component.literal((String)("Backup file not found: " + this.backupLocation)));
            }
            boolean removed = backupsStore.backups.removeIf(e -> Objects.equals(e.sha1, this.sha1) && Objects.equals(e.worldName, this.worldName) && Objects.equals(e.createTime, this.createTime));
            if (!removed) {
                throw new BackupException((Component)Component.literal((String)"Could not find backup in the FTBBackups 2 'backups.json' file."));
            }
            if (!FTBBackupProvider.writeBackupsJson(backupsStore)) {
                throw new BackupException((Component)Component.literal((String)"Failed to update the FTBBackups 2 'backups.json' file."));
            }
            if (!backup.delete()) {
                throw new BackupException((Component)Component.literal((String)("Backup entry was removed from the FTBBackups 2 'backups.json' file, But the actual backup file could not be deleted! You may need to delete the file manually: " + this.backupLocation)));
            }
        }

        @Override
        public void restore(String restoreName) throws BackupException {
            if (this.backupFormat != Format.ZIP) {
                throw new BackupException((Component)Component.literal((String)("Backup manager currently only supports backups using the zip format! (Found: " + String.valueOf((Object)this.backupFormat) + ")")));
            }
            FileSystem fileSystem = FileSystems.getDefault();
            Path backup = fileSystem.getPath(this.backupLocation, new String[0]);
            if (!Files.exists(backup, new LinkOption[0])) {
                throw new BackupException((Component)Component.literal((String)("Backup file not found: " + this.backupLocation)));
            }
            Path worldFolder = BackupManager.getSavesPath().resolve(this.getWorldFolderName(restoreName));
            Path temp = this.getTempDirectory();
            this.unzip(backup, temp);
            Path extracted = temp.resolve("saves/" + this.worldName);
            Path levelDat = extracted.resolve("level.dat");
            if (!Files.isDirectory(extracted, new LinkOption[0]) || !Files.exists(levelDat, new LinkOption[0])) {
                try {
                    FileUtils.deleteDirectory((File)temp.toFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new BackupException((Component)Component.literal((String)"Zip file contents do not match the expected structure of an FTB Backups 2 zip! Can not proceed."));
            }
            this.setWorldName(extracted, restoreName);
            this.smartMove(extracted, worldFolder);
            try {
                FileUtils.deleteDirectory((File)temp.toFile());
            }
            catch (IOException e) {
                BackupManager.LOGGER.error("Backup was restored but the temporary directory could not be deleted. " + String.valueOf(e));
                throw new BackupException((Component)Component.literal((String)("Backup was restored but the temporary directory could not be deleted: " + String.valueOf(temp.toAbsolutePath()))));
            }
        }

        @Override
        public FaviconTexture getIcon() {
            return this.icon;
        }

        @Override
        public void setIcon(FaviconTexture icon) {
            this.icon = icon;
        }
    }

    public static enum Format {
        ZIP,
        DIRECTORY;

    }
}

