/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner.world.level.block.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.blockrunner.BlockRunner;
import fuzs.blockrunner.init.ModRegistry;
import fuzs.neoforgedatapackextensions.api.v1.DataMapRegistry;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public record BlockSpeed(double speed) {
    public static final ResourceLocation SPEED_MODIFIER_BLOCK_SPEED_IDENTIFIER = BlockRunner.id("block_speed");
    static final double MAX_SPEED_VALUE = 8.0;
    public static final Codec<BlockSpeed> SPEED_CODEC = Codec.doubleRange((double)0.0, (double)8.0).xmap(BlockSpeed::new, BlockSpeed::speed);
    public static final Codec<BlockSpeed> CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(in -> in.group((App)Codec.doubleRange((double)0.0, (double)8.0).fieldOf("speed").forGetter(BlockSpeed::speed)).apply((Applicative)in, BlockSpeed::new)), SPEED_CODEC);

    public static boolean hasBlockSpeed(Block block) {
        return DataMapRegistry.INSTANCE.getData(ModRegistry.BLOCK_SPEED_DATA_MAP_TYPE, (Holder)block.builtInRegistryHolder()) != null;
    }

    public static double getSpeedFactor(Block block) {
        BlockSpeed blockSpeed = (BlockSpeed)DataMapRegistry.INSTANCE.getData(ModRegistry.BLOCK_SPEED_DATA_MAP_TYPE, (Holder)block.builtInRegistryHolder());
        return blockSpeed != null ? blockSpeed.speed() : 1.0;
    }
}

