/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.IDataRetainingTile;
import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.IBCoreBlock;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.IRedstoneEmitter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;

public class BlockBCore
extends Block
implements IBCoreBlock {
    public static final DataComponentType<CustomData> BC_TILE_DATA_TAG = DataComponents.CUSTOM_DATA;
    public static final String BC_MANAGED_DATA_FLAG = "bc_managed_data";
    protected boolean canProvidePower = false;
    protected boolean isMobResistant = false;
    protected boolean isExplosionResistant = false;
    private boolean blockSpawns = false;
    private boolean isLightTransparent = false;

    public BlockBCore(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockBCore setLightTransparent() {
        this.isLightTransparent = true;
        return this;
    }

    public BlockBCore setMobResistant() {
        this.isMobResistant = true;
        return this;
    }

    public BlockBCore setExplosionResistant() {
        this.isExplosionResistant = true;
        return this;
    }

    public float getShadeBrightness(BlockState p_60472_, BlockGetter p_60473_, BlockPos p_60474_) {
        return this.isLightTransparent ? 1.0f : super.getShadeBrightness(p_60472_, p_60473_, p_60474_);
    }

    public BlockBCore dontSpawnOnMe() {
        this.blockSpawns = true;
        return this;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof IDataRetainingTile && !BrandonsCore.proxy.isCTRLKeyDown()) {
            CompoundTag tileData = new CompoundTag();
            ((IDataRetainingTile)tile).writeToItemStack((HolderLookup.Provider)level.registryAccess(), tileData, false);
            if (!tileData.isEmpty()) {
                stack.set(BC_TILE_DATA_TAG, (Object)CustomData.of((CompoundTag)tileData));
            }
        }
        if (tile instanceof Nameable && ((Nameable)tile).hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)((Nameable)tile).getName());
        }
        return stack;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        if (this instanceof EntityBlockBCore) {
            BlockEntity tile = world.getBlockEntity(pos);
            return tile instanceof IRedstoneEmitter;
        }
        return this.canProvidePower || super.canConnectRedstone(state, world, pos, side);
    }

    public boolean isSignalSource(BlockState state) {
        return this.canProvidePower;
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter world, BlockPos pos, Direction side) {
        if (this instanceof EntityBlockBCore) {
            BlockEntity tile = world.getBlockEntity(pos);
            return tile instanceof IChangeListener;
        }
        return super.shouldCheckWeakPower(state, world, pos, side);
    }

    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity tile;
        if (this instanceof EntityBlockBCore && (tile = blockAccess.getBlockEntity(pos)) instanceof IRedstoneEmitter) {
            return ((IRedstoneEmitter)tile).getWeakPower(blockState, side);
        }
        return super.getSignal(blockState, blockAccess, pos, side);
    }

    public int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity tile;
        if (this instanceof EntityBlockBCore && (tile = blockAccess.getBlockEntity(pos)) instanceof IRedstoneEmitter) {
            return ((IRedstoneEmitter)tile).getStrongPower(blockState, side);
        }
        return super.getDirectSignal(blockState, blockAccess, pos, side);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity tile;
        if (this instanceof EntityBlockBCore && (tile = world.getBlockEntity(pos)) instanceof IChangeListener) {
            ((IChangeListener)tile).onNeighborChange(fromPos);
        }
        super.neighborChanged(state, world, pos, blockIn, fromPos, isMoving);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile;
        if (this instanceof EntityBlockBCore && (tile = level.getBlockEntity(pos)) instanceof IInteractTile) {
            return ((IInteractTile)tile).useItemOn(stack, state, player, hand, hit);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity tile;
        if (this instanceof EntityBlockBCore && (tile = level.getBlockEntity(pos)) instanceof IInteractTile) {
            return ((IInteractTile)tile).useWithoutItem(state, player, hit);
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    public void attack(BlockState state, Level world, BlockPos pos, Player player) {
        BlockEntity tile;
        if (this instanceof EntityBlockBCore && (tile = world.getBlockEntity(pos)) instanceof IInteractTile) {
            ((IInteractTile)tile).onBlockAttack(state, player);
        }
        super.attack(state, world, pos, player);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IDataRetainingTile && stack.has(BC_TILE_DATA_TAG) && !((CustomData)stack.get(BC_TILE_DATA_TAG)).isEmpty()) {
            ((IDataRetainingTile)tile).readFromItemStack((HolderLookup.Provider)world.registryAccess(), ((CustomData)stack.get(BC_TILE_DATA_TAG)).copyTag());
        }
        if (tile instanceof TileBCore && stack.has(DataComponents.CUSTOM_NAME)) {
            ((TileBCore)tile).setCustomName(stack.getHoverName().getString());
        }
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, BlockEntity te, ItemStack heldStack) {
        ItemStack stack = null;
        if (te instanceof IDataRetainingTile && ((IDataRetainingTile)te).saveToItem()) {
            CompoundTag tileData = new CompoundTag();
            ((IDataRetainingTile)te).writeToItemStack((HolderLookup.Provider)world.registryAccess(), tileData, true);
            if (!tileData.isEmpty()) {
                stack = new ItemStack((ItemLike)this, 1);
                stack.set(BC_TILE_DATA_TAG, (Object)CustomData.of((CompoundTag)tileData));
            }
        }
        if (te instanceof Nameable && ((Nameable)te).hasCustomName()) {
            if (stack == null) {
                stack = new ItemStack((ItemLike)this, 1);
            }
            stack.set(DataComponents.CUSTOM_NAME, (Object)((Nameable)te).getName());
        }
        if (stack != null) {
            player.awardStat(Stats.BLOCK_MINED.get((Object)this));
            player.causeFoodExhaustion(0.005f);
            BlockBCore.popResource((Level)world, (BlockPos)pos, (ItemStack)stack);
            world.removeBlockEntity(pos);
        } else {
            super.playerDestroy(world, player, pos, state, te, heldStack);
        }
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        if (!this.isMobResistant) {
            return super.canEntityDestroy(state, world, pos, entity);
        }
        return entity instanceof Player;
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (explosion.getIndirectSourceEntity() instanceof Mob && this.isMobResistant || this.isExplosionResistant) {
            return;
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    public boolean dropFromExplosion(Explosion explosion) {
        if (explosion.getIndirectSourceEntity() instanceof Mob && this.isMobResistant || this.isExplosionResistant) {
            return false;
        }
        return super.dropFromExplosion(explosion);
    }

    public static int getRedstonePower(LevelReader world, BlockPos pos, Direction facing) {
        BlockState blockstate = world.getBlockState(pos);
        return blockstate.shouldCheckWeakPower((SignalGetter)world, pos, facing) ? BlockBCore.getStrongPower(world, pos) : blockstate.getSignal((BlockGetter)world, pos, facing);
    }

    public static int getStrongPower(LevelReader world, BlockPos pos) {
        int i = 0;
        if ((i = Math.max(i, world.getDirectSignal(pos.below(), Direction.DOWN))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, world.getDirectSignal(pos.above(), Direction.UP))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, world.getDirectSignal(pos.north(), Direction.NORTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, world.getDirectSignal(pos.south(), Direction.SOUTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, world.getDirectSignal(pos.west(), Direction.WEST))) >= 15) {
            return i;
        }
        return Math.max(i, world.getDirectSignal(pos.east(), Direction.EAST));
    }

    public static boolean isBlockPowered(LevelReader world, BlockPos pos) {
        if (BlockBCore.getRedstonePower(world, pos.below(), Direction.DOWN) > 0) {
            return true;
        }
        if (BlockBCore.getRedstonePower(world, pos.above(), Direction.UP) > 0) {
            return true;
        }
        if (BlockBCore.getRedstonePower(world, pos.north(), Direction.NORTH) > 0) {
            return true;
        }
        if (BlockBCore.getRedstonePower(world, pos.south(), Direction.SOUTH) > 0) {
            return true;
        }
        if (BlockBCore.getRedstonePower(world, pos.west(), Direction.WEST) > 0) {
            return true;
        }
        return BlockBCore.getRedstonePower(world, pos.east(), Direction.EAST) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (stack.has(BC_TILE_DATA_TAG)) {
            tooltip.add((Component)Component.translatable((String)"info.brandonscore.block_has_saved_data"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean renderSelectionBox(RenderHighlightEvent.Block event, Level level) {
        return true;
    }
}

