/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging;

import dev.isxander.yacl3.platform.YACLPlatform;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import me.cg360.mod.bridging.config.BridgingConfig;
import me.cg360.mod.bridging.config.selector.SourcePerspective;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgingMod {
    public static final String MOD_ID = "bridgingmod";
    private static Set<String> compatibilityNeededMods = new HashSet<String>();

    public static void noteIncompatibleMod(String modId) {
        compatibilityNeededMods.add(modId.toLowerCase());
    }

    public static SourcePerspective getCompatibleSourcePerspective() {
        SourcePerspective cfgPerspective = BridgingMod.getConfig().getPerspectiveLock();
        if (cfgPerspective != SourcePerspective.LET_BRIDGING_MOD_DECIDE) {
            return cfgPerspective;
        }
        return compatibilityNeededMods.contains("freelook") ? SourcePerspective.ALWAYS_EYELINE : SourcePerspective.COPY_TOGGLE_PERSPECTIVE;
    }

    public static void init() {
        BridgingConfig.HANDLER.load();
    }

    public static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static BridgingConfig getConfig() {
        return (BridgingConfig)BridgingConfig.HANDLER.instance();
    }

    public static Logger getLogger() {
        return LoggerFactory.getLogger(BridgingMod.class);
    }

    public static Path getDefaultConfigPath() {
        return YACLPlatform.getConfigDir();
    }
}

