/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.config;

import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigHandler;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import speiger.src.collections.objects.sets.ObjectOpenHashSet;

public class HashSetCache<T> {
    private final Set<T> cache = new ObjectOpenHashSet();
    private final Consumer<Consumer<T>> provider;

    private HashSetCache(ConfigHandler configHandler, Consumer<Consumer<T>> provider) {
        this.provider = provider;
        configHandler.addLoadedListener(this::reload);
    }

    private void reload() {
        this.cache.clear();
        this.provider.accept(this.cache::add);
    }

    public boolean contains(T value) {
        return this.cache.contains(value);
    }

    public static <T> HashSetCache<T> create(ConfigEntry.ArrayConfigEntry<T> configEntry, ConfigHandler configHandler) {
        return new HashSetCache<T>(configHandler, T -> {
            for (Object val : (Object[])configEntry.getValue()) {
                T.accept(val);
            }
        });
    }

    public static <T, E extends Collection<T>> HashSetCache<T> create(ConfigEntry.CollectionConfigEntry<T, E> configEntry, ConfigHandler configHandler) {
        return new HashSetCache<T>(configHandler, T -> ((Collection)configEntry.getValue()).forEach(T));
    }
}

